/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public class ZonedDateTimeMapper
implements ResultColumnMapper<ZonedDateTime> {
    private Optional<Calendar> calendar;

    public ZonedDateTimeMapper() {
        this.calendar = Optional.empty();
    }

    public ZonedDateTimeMapper(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    private Optional<Calendar> cloneCalendar() {
        return this.calendar.map(Calendar::clone).map(x -> (Calendar)x);
    }

    @Nullable
    public ZonedDateTime mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        Optional<Calendar> instance = this.cloneCalendar();
        Timestamp timestamp = instance.isPresent() ? r.getTimestamp(columnNumber, instance.get()) : r.getTimestamp(columnNumber);
        return this.convertToZonedDateTime(timestamp);
    }

    @Nullable
    public ZonedDateTime mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        Optional<Calendar> instance = this.cloneCalendar();
        Timestamp timestamp = instance.isPresent() ? r.getTimestamp(columnLabel, instance.get()) : r.getTimestamp(columnLabel);
        return this.convertToZonedDateTime(timestamp);
    }

    @Nullable
    private ZonedDateTime convertToZonedDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Optional zoneId = this.calendar.flatMap(c -> Optional.of(c.getTimeZone().toZoneId()));
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp.getTime() / 1000L, timestamp.getNanos()), zoneId.orElse(ZoneId.systemDefault()));
    }
}

