/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.skipping;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.And;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Or;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.skipping.DataSkippingPredicate;
import io.delta.kernel.internal.skipping.StatsSchemaHelper;
import io.delta.kernel.internal.util.ExpressionUtils;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DataSkippingUtils {
    private static final Map<String, String> REVERSE_COMPARATORS = new HashMap<String, String>(){
        {
            this.put("=", "=");
            this.put("<", ">");
            this.put("<=", ">=");
            this.put(">", "<");
            this.put(">=", "<=");
        }
    };

    public static ColumnarBatch parseJsonStats(Engine engine, FilteredColumnarBatch filteredColumnarBatch, StructType structType) {
        ColumnVector columnVector = filteredColumnarBatch.getData().getColumnVector(InternalScanFileUtils.ADD_FILE_ORDINAL).getChild(InternalScanFileUtils.ADD_FILE_STATS_ORDINAL);
        return engine.getJsonHandler().parseJson(columnVector, structType, filteredColumnarBatch.getSelectionVector());
    }

    public static StructType pruneStatsSchema(StructType structType, Set<Column> set) {
        return DataSkippingUtils.pruneSchema(set, structType, new String[0]);
    }

    public static Optional<DataSkippingPredicate> constructDataSkippingFilter(Predicate predicate, StructType structType) {
        StatsSchemaHelper statsSchemaHelper = new StatsSchemaHelper(structType);
        return DataSkippingUtils.constructDataSkippingFilter(predicate, statsSchemaHelper);
    }

    private static Optional<DataSkippingPredicate> constructDataSkippingFilter(Predicate predicate, StatsSchemaHelper statsSchemaHelper) {
        switch (predicate.getName().toUpperCase(Locale.ROOT)) {
            case "AND": {
                Optional<DataSkippingPredicate> optional = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate)), statsSchemaHelper);
                Optional<DataSkippingPredicate> optional2 = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)), statsSchemaHelper);
                if (optional.isPresent() && optional2.isPresent()) {
                    return Optional.of(new DataSkippingPredicate("AND", optional.get(), optional2.get()));
                }
                if (optional.isPresent()) {
                    return optional;
                }
                return optional2;
            }
            case "OR": {
                Optional<DataSkippingPredicate> optional = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate)), statsSchemaHelper);
                Optional<DataSkippingPredicate> optional3 = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)), statsSchemaHelper);
                if (optional.isPresent() && optional3.isPresent()) {
                    return Optional.of(new DataSkippingPredicate("OR", optional.get(), optional3.get()));
                }
                return Optional.empty();
            }
            case "IS_NOT_NULL": {
                Expression expression = ExpressionUtils.getUnaryChild(predicate);
                if (!(expression instanceof Column)) break;
                Column column = (Column)expression;
                if (!statsSchemaHelper.isSkippingEligibleNullCountColumn((Column)expression)) break;
                final Column column2 = statsSchemaHelper.getNullCountColumn(column);
                final Column column3 = statsSchemaHelper.getNumRecordsColumn();
                return Optional.of(new DataSkippingPredicate("<", Arrays.asList(column2, column3), (Set<Column>)new HashSet<Column>(){
                    {
                        this.add(column2);
                        this.add(column3);
                    }
                }));
            }
            case "IS_NULL": {
                Expression expression = ExpressionUtils.getUnaryChild(predicate);
                if (!(expression instanceof Column)) break;
                Column column = (Column)expression;
                if (!statsSchemaHelper.isSkippingEligibleNullCountColumn((Column)expression)) break;
                Column column4 = statsSchemaHelper.getNullCountColumn(column);
                Literal literal = Literal.ofLong(0L);
                return Optional.of(new DataSkippingPredicate(">", Arrays.asList(column4, literal), Collections.singleton(column4)));
            }
            case "=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                Expression expression = ExpressionUtils.getLeft(predicate);
                Expression expression2 = ExpressionUtils.getRight(predicate);
                if (expression instanceof Column && expression2 instanceof Literal) {
                    Column column = (Column)expression;
                    Literal literal = (Literal)expression2;
                    if (!statsSchemaHelper.isSkippingEligibleMinMaxColumn(column)) break;
                    if (!StatsSchemaHelper.isSkippingEligibleLiteral(literal)) break;
                    return Optional.of(DataSkippingUtils.constructComparatorDataSkippingFilters(predicate.getName(), column, literal, statsSchemaHelper));
                }
                if (!(expression2 instanceof Column) || !(expression instanceof Literal)) break;
                return DataSkippingUtils.constructDataSkippingFilter(DataSkippingUtils.reverseComparatorFilter(predicate), statsSchemaHelper);
            }
            case "NOT": {
                return DataSkippingUtils.constructNotDataSkippingFilters(ExpressionUtils.asPredicate(ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
        }
        return Optional.empty();
    }

    private static DataSkippingPredicate constructComparatorDataSkippingFilters(String string, Column column, Literal literal, StatsSchemaHelper statsSchemaHelper) {
        switch (string.toUpperCase(Locale.ROOT)) {
            case "=": {
                return new DataSkippingPredicate("AND", DataSkippingUtils.constructBinaryDataSkippingPredicate("<=", statsSchemaHelper.getMinColumn(column), literal), DataSkippingUtils.constructBinaryDataSkippingPredicate(">=", statsSchemaHelper.getMaxColumn(column), literal));
            }
            case "<": {
                return DataSkippingUtils.constructBinaryDataSkippingPredicate("<", statsSchemaHelper.getMinColumn(column), literal);
            }
            case "<=": {
                return DataSkippingUtils.constructBinaryDataSkippingPredicate("<=", statsSchemaHelper.getMinColumn(column), literal);
            }
            case ">": {
                return DataSkippingUtils.constructBinaryDataSkippingPredicate(">", statsSchemaHelper.getMaxColumn(column), literal);
            }
            case ">=": {
                return DataSkippingUtils.constructBinaryDataSkippingPredicate(">=", statsSchemaHelper.getMaxColumn(column), literal);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported comparator expression %s", string));
    }

    private static DataSkippingPredicate constructBinaryDataSkippingPredicate(String string, final Column column, Literal literal) {
        return new DataSkippingPredicate(string, Arrays.asList(column, literal), (Set<Column>)new HashSet<Column>(){
            {
                this.add(column);
            }
        });
    }

    private static Predicate reverseComparatorFilter(Predicate predicate) {
        return new Predicate(REVERSE_COMPARATORS.get(predicate.getName().toUpperCase(Locale.ROOT)), ExpressionUtils.getRight(predicate), ExpressionUtils.getLeft(predicate));
    }

    private static Optional<DataSkippingPredicate> constructNotDataSkippingFilters(Predicate predicate, StatsSchemaHelper statsSchemaHelper) {
        switch (predicate.getName().toUpperCase(Locale.ROOT)) {
            case "AND": {
                return DataSkippingUtils.constructDataSkippingFilter((Predicate)new Or(new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate))), new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)))), statsSchemaHelper);
            }
            case "OR": {
                return DataSkippingUtils.constructDataSkippingFilter((Predicate)new And(new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate))), new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)))), statsSchemaHelper);
            }
            case "IS_NOT_NULL": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("IS_NULL", ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
            case "IS_NULL": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("IS_NOT_NULL", ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
            case "=": {
                Expression expression = ExpressionUtils.getLeft(predicate);
                Expression expression2 = ExpressionUtils.getRight(predicate);
                if (expression instanceof Column && expression2 instanceof Literal) {
                    Column column = (Column)expression;
                    Literal literal = (Literal)expression2;
                    if (!statsSchemaHelper.isSkippingEligibleMinMaxColumn(column)) break;
                    if (!StatsSchemaHelper.isSkippingEligibleLiteral(literal)) break;
                    return Optional.of(new DataSkippingPredicate("OR", DataSkippingUtils.constructBinaryDataSkippingPredicate("<", statsSchemaHelper.getMinColumn(column), literal), DataSkippingUtils.constructBinaryDataSkippingPredicate(">", statsSchemaHelper.getMaxColumn(column), literal)));
                }
                if (!(expression2 instanceof Column) || !(expression instanceof Literal)) break;
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("NOT", new Predicate("=", expression2, expression)), statsSchemaHelper);
            }
            case "<": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate(">=", predicate.getChildren()), statsSchemaHelper);
            }
            case "<=": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate(">", predicate.getChildren()), statsSchemaHelper);
            }
            case ">": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("<=", predicate.getChildren()), statsSchemaHelper);
            }
            case ">=": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("<", predicate.getChildren()), statsSchemaHelper);
            }
            case "NOT": {
                return DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
        }
        return Optional.empty();
    }

    private static StructType pruneSchema(Set<Column> set, StructType structType, String[] stringArray) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        for (StructField structField : structType.fields()) {
            String[] stringArray2 = DataSkippingUtils.appendArray(stringArray, structField.getName());
            if (structField.getDataType() instanceof StructType) {
                StructType structType2 = DataSkippingUtils.pruneSchema(set, (StructType)structField.getDataType(), stringArray2);
                if (structType2.length() <= 0) continue;
                arrayList.add(new StructField(structField.getName(), structType2, structField.isNullable(), structField.getMetadata()));
                continue;
            }
            if (!set.contains(new Column(stringArray2))) continue;
            arrayList.add(structField);
        }
        return new StructType(arrayList);
    }

    private static String[] appendArray(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }
}

