/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Transaction;
import io.delta.kernel.TransactionCommitResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.ConcurrentWriteException;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.data.TransactionStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.ConflictChecker;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterable;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    public static final int DEFAULT_READ_VERSION = 1;
    public static final int DEFAULT_WRITE_VERSION = 2;
    private static final int NUM_TXN_RETRIES = 200;
    private final UUID txnId = UUID.randomUUID();
    private final boolean isNewTable;
    private final String engineInfo;
    private final Operation operation;
    private final Path dataPath;
    private final Path logPath;
    private final Protocol protocol;
    private final Metadata metadata;
    private final SnapshotImpl readSnapshot;
    private final Optional<SetTransaction> setTxnOpt;
    private boolean closed;

    public TransactionImpl(boolean bl, Path path, Path path2, SnapshotImpl snapshotImpl, String string, Operation operation, Protocol protocol, Metadata metadata, Optional<SetTransaction> optional) {
        this.isNewTable = bl;
        this.dataPath = path;
        this.logPath = path2;
        this.readSnapshot = snapshotImpl;
        this.engineInfo = string;
        this.operation = operation;
        this.protocol = protocol;
        this.metadata = metadata;
        this.setTxnOpt = optional;
    }

    @Override
    public Row getTransactionState(Engine engine) {
        return TransactionStateRow.of(this.metadata, this.dataPath.toString());
    }

    @Override
    public List<String> getPartitionColumns(Engine engine) {
        return VectorUtils.toJavaList(this.metadata.getPartitionColumns());
    }

    @Override
    public StructType getSchema(Engine engine) {
        return this.readSnapshot.getSchema(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionCommitResult commit(Engine engine, CloseableIterable<Row> closeableIterable) throws ConcurrentWriteException {
        Preconditions.checkState(!this.closed, "Transaction is already attempted to commit. Create a new transaction.");
        long l = this.readSnapshot.getVersion(engine) + 1L;
        int n = 0;
        while (true) {
            logger.info("Committing transaction as version = {}.", (Object)l);
            try {
                TransactionCommitResult transactionCommitResult = this.doCommit(engine, l, closeableIterable);
                this.closed = true;
                return transactionCommitResult;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                try {
                    logger.info("Concurrent write detected when committing as version = {}. Trying to resolve conflicts and retry commit.", (Object)l);
                    ConflictChecker.TransactionRebaseState transactionRebaseState = ConflictChecker.resolveConflicts(engine, this.readSnapshot, l, this);
                    long l2 = transactionRebaseState.getLatestVersion() + 1L;
                    Preconditions.checkArgument(l < l2, "New commit version %d should be greater than the previous commit attempt version %d.", l2, l);
                    l = l2;
                    if (++n < 200) continue;
                    this.closed = true;
                }
                catch (Throwable throwable) {
                    this.closed = true;
                    throw throwable;
                }
            }
            break;
        }
        logger.info("Exhausted maximum retries ({}) for committing transaction.", (Object)200);
        throw new ConcurrentWriteException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransactionCommitResult doCommit(Engine engine, long l, CloseableIterable<Row> closeableIterable) throws FileAlreadyExistsException {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        arrayList.add(SingleAction.createCommitInfoSingleAction(this.generateCommitAction()));
        if (this.isNewTable) {
            arrayList.add(SingleAction.createMetadataSingleAction(this.metadata.toRow()));
            arrayList.add(SingleAction.createProtocolSingleAction(this.protocol.toRow()));
        }
        this.setTxnOpt.ifPresent(setTransaction -> arrayList.add(SingleAction.createTxnSingleAction(setTransaction.toRow())));
        try (Iterator iterator = closeableIterable.iterator();){
            CloseableIterator<Row> closeableIterator = Utils.toCloseableIterator(arrayList.iterator()).combine(iterator);
            if (l == 0L && !engine.getFileSystemClient().mkdirs(this.logPath.toString())) {
                throw new RuntimeException("Failed to create delta log directory: " + this.logPath);
            }
            engine.getJsonHandler().writeJsonFileAtomically(FileNames.deltaFile(this.logPath, l), closeableIterator, false);
            TransactionCommitResult transactionCommitResult = new TransactionCommitResult(l, this.isReadyForCheckpoint(l));
            return transactionCommitResult;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw fileAlreadyExistsException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public boolean isBlindAppend() {
        return true;
    }

    public Optional<SetTransaction> getSetTxnOpt() {
        return this.setTxnOpt;
    }

    private Row generateCommitAction() {
        return new CommitInfo(System.currentTimeMillis(), "Kernel-3.2.1/" + this.engineInfo, this.operation.getDescription(), this.getOperationParameters(), this.isBlindAppend(), this.txnId.toString()).toRow();
    }

    private boolean isReadyForCheckpoint(long l) {
        int n = TableConfig.CHECKPOINT_INTERVAL.fromMetadata(this.metadata);
        return l > 0L && l % (long)n == 0L;
    }

    private Map<String, String> getOperationParameters() {
        if (this.isNewTable) {
            List list = VectorUtils.toJavaList(this.metadata.getPartitionColumns());
            String string2 = list.stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(",", "[", "]"));
            return Collections.singletonMap("partitionBy", string2);
        }
        return Collections.emptyMap();
    }

    public static List<Column> getStatisticsColumns(Engine engine, Row row) {
        return Collections.emptyList();
    }
}

