/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.util.IntervalParserUtils;
import java.util.function.Function;
import java.util.function.Predicate;

public class TableConfig<T> {
    public static final TableConfig<Long> TOMBSTONE_RETENTION = new TableConfig<Long>("delta.deletedFileRetentionDuration", "interval 1 week", IntervalParserUtils::safeParseIntervalAsMillis, l -> l >= 0L, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.");
    public static final TableConfig<Integer> CHECKPOINT_INTERVAL = new TableConfig<Integer>("delta.checkpointInterval", "10", Integer::valueOf, n -> n > 0, "needs to be a positive integer.");
    private final String key;
    private final String defaultValue;
    private final Function<String, T> fromString;
    private final Predicate<T> validator;
    private final String helpMessage;

    private TableConfig(String string, String string2, Function<String, T> function, Predicate<T> predicate, String string3) {
        this.key = string;
        this.defaultValue = string2;
        this.fromString = function;
        this.validator = predicate;
        this.helpMessage = string3;
    }

    public T fromMetadata(Metadata metadata) {
        T t = this.fromString.apply(metadata.getConfiguration().getOrDefault(this.key, this.defaultValue));
        if (!this.validator.test(t)) {
            throw new IllegalArgumentException(String.format("Invalid value for table property '%s': '%s'. %s", this.key, t, this.helpMessage));
        }
        return t;
    }
}

