/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.exceptions.ConcurrentTransactionException;
import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.exceptions.MetadataChangedException;
import io.delta.kernel.exceptions.ProtocolChangedException;
import io.delta.kernel.exceptions.TableAlreadyExistsException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import java.sql.Timestamp;
import java.util.List;

public final class DeltaErrors {
    private DeltaErrors() {
    }

    public static KernelException versionBeforeFirstAvailableCommit(String string, long l, long l2) {
        String string2 = String.format("%s: Cannot load table version %s as the transaction log has been truncated due to manual deletion or the log/checkpoint retention policy. The earliest available version is %s.", string, l, l2);
        return new KernelException(string2);
    }

    public static KernelException versionAfterLatestCommit(String string, long l, long l2) {
        String string2 = String.format("%s: Cannot load table version %s as it does not exist. The latest available version is %s.", string, l, l2);
        return new KernelException(string2);
    }

    public static KernelException timestampBeforeFirstAvailableCommit(String string, long l, long l2, long l3) {
        String string2 = String.format("%s: The provided timestamp %s ms (%s) is before the earliest available version %s. Please use a timestamp greater than or equal to %s ms (%s).", string, l, DeltaErrors.formatTimestamp(l), l3, l2, DeltaErrors.formatTimestamp(l2));
        return new KernelException(string2);
    }

    public static KernelException timestampAfterLatestCommit(String string, long l, long l2, long l3) {
        String string2 = String.format("%s: The provided timestamp %s ms (%s) is after the latest available version %s. Please use a timestamp less than or equal to %s ms (%s).", string, l, DeltaErrors.formatTimestamp(l), l3, l2, DeltaErrors.formatTimestamp(l2));
        return new KernelException(string2);
    }

    public static KernelException unsupportedReaderProtocol(String string, int n) {
        String string2 = String.format("Unsupported Delta protocol reader version: table `%s` requires reader version %s which is unsupported by this version of Delta Kernel.", string, n);
        return new KernelException(string2);
    }

    public static KernelException unsupportedReaderFeature(String string, String string2) {
        String string3 = String.format("Unsupported Delta reader feature: table `%s` requires reader table feature \"%s\" which is unsupported by this version of Delta Kernel.", string, string2);
        return new KernelException(string3);
    }

    public static KernelException unsupportedWriterProtocol(String string, int n) {
        String string2 = String.format("Unsupported Delta protocol writer version: table `%s` requires writer version %s which is unsupported by this version of Delta Kernel.", string, n);
        return new KernelException(string2);
    }

    public static KernelException unsupportedWriterFeature(String string, String string2) {
        String string3 = String.format("Unsupported Delta writer feature: table `%s` requires writer table feature \"%s\" which is unsupported by this version of Delta Kernel.", string, string2);
        return new KernelException(string3);
    }

    public static KernelException columnInvariantsNotSupported() {
        String string = "This version of Delta Kernel does not support writing to tables with column invariants present.";
        return new KernelException(string);
    }

    public static KernelException unsupportedDataType(DataType dataType) {
        return new KernelException("Kernel doesn't support writing data of type: " + dataType);
    }

    public static KernelException unsupportedPartitionDataType(String string, DataType dataType) {
        String string2 = "Kernel doesn't support writing data with partition column (%s) of type: %s";
        return new KernelException(String.format(string2, string, dataType));
    }

    public static KernelException duplicateColumnsInSchema(StructType structType, List<String> list) {
        String string = String.format("Schema contains duplicate columns: %s.\nSchema: %s", String.join((CharSequence)", ", list), structType);
        return new KernelException(string);
    }

    public static KernelException invalidColumnName(String string, String string2) {
        return new KernelException(String.format("Column name '%s' contains one of the unsupported (%s) characters.", string, string2));
    }

    public static KernelException requiresSchemaForNewTable(String string) {
        return new TableNotFoundException(string, "Must provide a new schema to write to a new table.");
    }

    public static KernelException tableAlreadyExists(String string, String string2) {
        return new TableAlreadyExistsException(string, string2);
    }

    public static KernelException dataSchemaMismatch(String string, StructType structType, StructType structType2) {
        String string2 = "The schema of the data to be written to the table doesn't match the table schema. \nTable: %s\nTable schema: %s, \nData schema: %s";
        return new KernelException(String.format(string2, string, structType, structType2));
    }

    public static KernelException partitionColumnMissingInData(String string, String string2) {
        String string3 = "Missing partition column '%s' in the data to be written to the table '%s'.";
        return new KernelException(String.format(string3, string2, string));
    }

    public static KernelException concurrentTransaction(String string, long l, long l2) {
        return new ConcurrentTransactionException(string, l, l2);
    }

    public static KernelException metadataChangedException() {
        return new MetadataChangedException();
    }

    public static KernelException protocolChangedException(long l) {
        return new ProtocolChangedException(l);
    }

    public static KernelException voidTypeEncountered() {
        return new KernelException("Failed to parse the schema. Encountered unsupported Delta data type: VOID");
    }

    private static String formatTimestamp(long l) {
        return new Timestamp(l).toInstant().toString();
    }
}

