package io.dekorate.openshift.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

 /**
  * Generated
  */
public class Route{
  public Route() {
  }
  public Route(Boolean expose,String host,String targetPort) {
    this.expose = expose;
    this.host = host;
    this.targetPort = targetPort;
  }
  private Boolean expose;
  private String host;
  private String targetPort;
  
  /**
   * Controls whether the application should be exposed via Route
   */
public Boolean getExpose() {
    return this.expose;
  }
  
  /**
   * Controls whether the application should be exposed via Route
   */
public boolean isExpose() {
    return this.expose != null &&  this.expose;
  }
  
  /**
   * The host under which the application is going to be exposed.
   * @return The hostname.
   */
public String getHost() {
    return this.host;
  }
  
  /**
   * @return The target named port. If not provided, it will be deducted from the Service resource ports.
   */
public String getTargetPort() {
    return this.targetPort;
  }
  public static RouteBuilder newBuilder() {
    return new RouteBuilder();
  }
  public static RouteBuilder newBuilderFromDefaults() {
    return new RouteBuilder().withExpose(false);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Route that = (Route) o;
    if (expose != null ? !expose.equals(that.expose) :that.expose != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(expose,  host,  targetPort,  super.hashCode());
  }
  
}