package io.dekorate.openshift.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import java.util.function.Predicate;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import java.lang.Deprecated;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.ContainerFluent;
import java.util.Iterator;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import java.util.List;
import io.dekorate.kubernetes.config.Job;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.HostAlias;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.CronJob;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

 /**
  * Generated
  */
public interface OpenshiftConfigFluent<A extends OpenshiftConfigFluent<A>> extends BaseConfigFluent<A>{
  public A withInitContainers(io.dekorate.kubernetes.config.Container... initContainers);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   */
  @Deprecated
  public Container[] getInitContainers();
  public Container[] buildInitContainers();
  public Container buildInitContainer(Integer index);
  public Container buildFirstInitContainer();
  public Container buildLastInitContainer();
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A addToInitContainers(Integer index,Container item);
  public A setToInitContainers(Integer index,Container item);
  public A addToInitContainers(io.dekorate.kubernetes.config.Container... items);
  public A addAllToInitContainers(Collection<Container> items);
  public A removeFromInitContainers(io.dekorate.kubernetes.config.Container... items);
  public A removeAllFromInitContainers(Collection<Container> items);
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
  public Boolean hasInitContainers();
  public OpenshiftConfigFluent.InitContainersNested<A> addNewInitContainer();
  public OpenshiftConfigFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
  public OpenshiftConfigFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item);
  public OpenshiftConfigFluent.InitContainersNested<A> editInitContainer(Integer index);
  public OpenshiftConfigFluent.InitContainersNested<A> editFirstInitContainer();
  public OpenshiftConfigFluent.InitContainersNested<A> editLastInitContainer();
  public OpenshiftConfigFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  
  /**
   * This method has been deprecated, please use method buildRoute instead.
   * @return The buildable object.
   */
  @Deprecated
  public Route getRoute();
  public Route buildRoute();
  public A withRoute(Route route);
  public Boolean hasRoute();
  public A withNewRoute(Boolean expose,String host,String targetPort);
  public OpenshiftConfigFluent.RouteNested<A> withNewRoute();
  public OpenshiftConfigFluent.RouteNested<A> withNewRouteLike(Route item);
  public OpenshiftConfigFluent.RouteNested<A> editRoute();
  public OpenshiftConfigFluent.RouteNested<A> editOrNewRoute();
  public OpenshiftConfigFluent.RouteNested<A> editOrNewRouteLike(Route item);
  public Boolean getHeadless();
  public A withHeadless(Boolean headless);
  public Boolean hasHeadless();
  public A withHeadless();
  public interface InitContainersNested<N> extends Nested<N>,ContainerFluent<OpenshiftConfigFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface RouteNested<N> extends Nested<N>,RouteFluent<OpenshiftConfigFluent.RouteNested<N>>{
    public N and();
    public N endRoute();
    
  }
  
}