/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.decorator.AddRouteDecorator;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@Description(value="Add the port to the Route resource.")
public class AddPortToRouteDecorator
extends NamedResourceDecorator<RouteSpecFluent<?>>
implements WithConfigReferences {
    private final OpenshiftConfig config;

    public AddPortToRouteDecorator(OpenshiftConfig config) {
        this.config = config;
    }

    public void andThenVisit(RouteSpecFluent<?> spec, ObjectMeta resourceMeta) {
        Optional<Port> port = this.getNamedHttpPort(this.config);
        if (!port.isPresent()) {
            return;
        }
        if (!spec.hasPath().booleanValue()) {
            spec.withPath(port.get().getPath());
        }
        if (!spec.hasPort().booleanValue()) {
            ((RouteSpecFluent.PortNested)spec.editOrNewPort().withNewTargetPort((Object)port.get().getName())).endPort();
        }
    }

    private Optional<Port> getNamedHttpPort(OpenshiftConfig config) {
        String namedPortName = config.getRoute().getTargetPort();
        if (Strings.isNotNullOrEmpty((String)namedPortName)) {
            Optional port = Ports.getPortByFilter(p -> Strings.equals((String)p.getName(), (String)namedPortName), (BaseConfig)config);
            if (port.isPresent()) {
                return port;
            }
            return Optional.of(((PortBuilder)Port.newBuilder().withName(namedPortName)).build());
        }
        return Ports.getHttpPort((BaseConfig)config);
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddRouteDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferencePath());
    }

    private ConfigReference buildConfigReferencePath() {
        String property = "path";
        String path = "(kind == Route && metadata.name == " + this.getName() + ").spec.path";
        return new ConfigReference(property, path);
    }
}

