package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressRuleFluentImpl<A extends IngressRuleFluent<A>> extends BaseFluent<A> implements IngressRuleFluent<A>{
  public IngressRuleFluentImpl() {
  }
  public IngressRuleFluentImpl(IngressRule instance) {
    this.withHost(instance.getHost()); 
    this.withPath(instance.getPath()); 
    this.withPathType(instance.getPathType()); 
    this.withServiceName(instance.getServiceName()); 
    this.withServicePortName(instance.getServicePortName()); 
    this.withServicePortNumber(instance.getServicePortNumber()); 
  }
  private String host;
  private String path;
  private String pathType;
  private String serviceName;
  private String servicePortName;
  private Integer servicePortNumber;
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getPathType() {
    return this.pathType;
  }
  public A withPathType(String pathType) {
    this.pathType=pathType; return (A) this;
  }
  public Boolean hasPathType() {
    return this.pathType != null;
  }
  public String getServiceName() {
    return this.serviceName;
  }
  public A withServiceName(String serviceName) {
    this.serviceName=serviceName; return (A) this;
  }
  public Boolean hasServiceName() {
    return this.serviceName != null;
  }
  public String getServicePortName() {
    return this.servicePortName;
  }
  public A withServicePortName(String servicePortName) {
    this.servicePortName=servicePortName; return (A) this;
  }
  public Boolean hasServicePortName() {
    return this.servicePortName != null;
  }
  public Integer getServicePortNumber() {
    return this.servicePortNumber;
  }
  public A withServicePortNumber(Integer servicePortNumber) {
    this.servicePortNumber=servicePortNumber; return (A) this;
  }
  public Boolean hasServicePortNumber() {
    return this.servicePortNumber != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressRuleFluentImpl that = (IngressRuleFluentImpl) o;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (pathType != null ? !pathType.equals(that.pathType) :that.pathType != null) return false;
    if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
    if (servicePortName != null ? !servicePortName.equals(that.servicePortName) :that.servicePortName != null) return false;
    if (servicePortNumber != null ? !servicePortNumber.equals(that.servicePortNumber) :that.servicePortNumber != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  path,  pathType,  serviceName,  servicePortName,  servicePortNumber,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (pathType != null) { sb.append("pathType:"); sb.append(pathType + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName + ","); }
    if (servicePortName != null) { sb.append("servicePortName:"); sb.append(servicePortName + ","); }
    if (servicePortNumber != null) { sb.append("servicePortNumber:"); sb.append(servicePortNumber); }
    sb.append("}");
    return sb.toString();
  }
  
}