package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;

 /**
  * Generated
  */
public class IngressRule{
  public IngressRule() {
  }
  public IngressRule(String host,String path,String pathType,String serviceName,String servicePortName,Integer servicePortNumber) {
    this.host = host;
    this.path = path;
    this.pathType = pathType;
    this.serviceName = serviceName;
    this.servicePortName = servicePortName;
    this.servicePortNumber = servicePortNumber;
  }
  private String host;
  private String path;
  private String pathType;
  private String serviceName;
  private String servicePortName;
  private Integer servicePortNumber;
  
  /**
   * The host under which the rule is going to be used.
   */
public String getHost() {
    return this.host;
  }
  
  /**
   * The path under which the rule is going to be used. Default is "/".
   */
public String getPath() {
    return this.path;
  }
  
  /**
   * The path type strategy to use by the Ingress rule. Default is "Prefix".
   */
public String getPathType() {
    return this.pathType;
  }
  
  /**
   * The service name to be used by this Ingress rule. Default is the generated service name of the application.
   */
public String getServiceName() {
    return this.serviceName;
  }
  
  /**
   * The service port name to be used by this Ingress rule. Default is the port name of the generated service
   * of the application.
   */
public String getServicePortName() {
    return this.servicePortName;
  }
  
  /**
   * The service port number to be used by this Ingress rule. This is only used when the servicePortName is not set.
   */
public Integer getServicePortNumber() {
    return this.servicePortNumber;
  }
  public static IngressRuleBuilder newBuilder() {
    return new IngressRuleBuilder();
  }
  public static IngressRuleBuilder newBuilderFromDefaults() {
    return new IngressRuleBuilder().withPath("/").withPathType("Prefix").withServicePortNumber(-1);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressRule that = (IngressRule) o;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (pathType != null ? !pathType.equals(that.pathType) :that.pathType != null) return false;
    if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
    if (servicePortName != null ? !servicePortName.equals(that.servicePortName) :that.servicePortName != null) return false;
    if (servicePortNumber != null ? !servicePortNumber.equals(that.servicePortNumber) :that.servicePortNumber != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  path,  pathType,  serviceName,  servicePortName,  servicePortNumber,  super.hashCode());
  }
  
}