package io.dekorate.knative.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import java.util.function.Predicate;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import java.util.List;
import io.dekorate.kubernetes.config.Job;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.CronJob;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.fabric8.kubernetes.api.builder.Nested;
import io.dekorate.kubernetes.config.Env;
import java.lang.Deprecated;
import java.util.Iterator;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.HostAlias;
import java.lang.Integer;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;

 /**
  * Generated
  */
public interface KnativeConfigFluent<A extends KnativeConfigFluent<A>> extends BaseConfigFluent<A>{
  public String getRevisionName();
  public A withRevisionName(String revisionName);
  public Boolean hasRevisionName();
  public String getHost();
  public A withHost(String host);
  public Boolean hasHost();
  public HttpTransportVersion getHttpTransportVersion();
  public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion);
  public Boolean hasHttpTransportVersion();
  public Boolean getExpose();
  public A withExpose(Boolean expose);
  public Boolean hasExpose();
  public Integer getMinScale();
  public A withMinScale(Integer minScale);
  public Boolean hasMinScale();
  public Integer getMaxScale();
  public A withMaxScale(Integer maxScale);
  public Boolean hasMaxScale();
  public Boolean getScaleToZeroEnabled();
  public A withScaleToZeroEnabled(Boolean scaleToZeroEnabled);
  public Boolean hasScaleToZeroEnabled();
  
  /**
   * This method has been deprecated, please use method buildRevisionAutoScaling instead.
   * @return The buildable object.
   */
  @Deprecated
  public AutoScaling getRevisionAutoScaling();
  public AutoScaling buildRevisionAutoScaling();
  public A withRevisionAutoScaling(AutoScaling revisionAutoScaling);
  public Boolean hasRevisionAutoScaling();
  public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScaling();
  public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(AutoScaling item);
  public KnativeConfigFluent.RevisionAutoScalingNested<A> editRevisionAutoScaling();
  public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling();
  public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(AutoScaling item);
  
  /**
   * This method has been deprecated, please use method buildGlobalAutoScaling instead.
   * @return The buildable object.
   */
  @Deprecated
  public GlobalAutoScaling getGlobalAutoScaling();
  public GlobalAutoScaling buildGlobalAutoScaling();
  public A withGlobalAutoScaling(GlobalAutoScaling globalAutoScaling);
  public Boolean hasGlobalAutoScaling();
  public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScaling();
  public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(GlobalAutoScaling item);
  public KnativeConfigFluent.GlobalAutoScalingNested<A> editGlobalAutoScaling();
  public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling();
  public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(GlobalAutoScaling item);
  public String getTemplateName();
  public A withTemplateName(String templateName);
  public Boolean hasTemplateName();
  public A withTraffic(io.dekorate.knative.config.Traffic... traffic);
  
  /**
   * This method has been deprecated, please use method buildTraffic instead.
   */
  @Deprecated
  public Traffic[] getTraffic();
  public Traffic[] buildTraffic();
  public Traffic buildTraffic(Integer index);
  public Traffic buildFirstTraffic();
  public Traffic buildLastTraffic();
  public Traffic buildMatchingTraffic(Predicate<TrafficBuilder> predicate);
  public Boolean hasMatchingTraffic(Predicate<TrafficBuilder> predicate);
  public A addToTraffic(Integer index,Traffic item);
  public A setToTraffic(Integer index,Traffic item);
  public A addToTraffic(io.dekorate.knative.config.Traffic... items);
  public A addAllToTraffic(Collection<Traffic> items);
  public A removeFromTraffic(io.dekorate.knative.config.Traffic... items);
  public A removeAllFromTraffic(Collection<Traffic> items);
  public A removeMatchingFromTraffic(Predicate<TrafficBuilder> predicate);
  public Boolean hasTraffic();
  public A addNewTraffic(String tag,String revisionName,Boolean latestRevision,Integer percentage);
  public KnativeConfigFluent.TrafficNested<A> addNewTraffic();
  public KnativeConfigFluent.TrafficNested<A> addNewTrafficLike(Traffic item);
  public KnativeConfigFluent.TrafficNested<A> setNewTrafficLike(Integer index,Traffic item);
  public KnativeConfigFluent.TrafficNested<A> editTraffic(Integer index);
  public KnativeConfigFluent.TrafficNested<A> editFirstTraffic();
  public KnativeConfigFluent.TrafficNested<A> editLastTraffic();
  public KnativeConfigFluent.TrafficNested<A> editMatchingTraffic(Predicate<TrafficBuilder> predicate);
  public A withExpose();
  public A withScaleToZeroEnabled();
  public interface RevisionAutoScalingNested<N> extends Nested<N>,AutoScalingFluent<KnativeConfigFluent.RevisionAutoScalingNested<N>>{
    public N and();
    public N endRevisionAutoScaling();
    
  }
  public interface GlobalAutoScalingNested<N> extends Nested<N>,GlobalAutoScalingFluent<KnativeConfigFluent.GlobalAutoScalingNested<N>>{
    public N and();
    public N endGlobalAutoScaling();
    
  }
  public interface TrafficNested<N> extends Nested<N>,TrafficFluent<KnativeConfigFluent.TrafficNested<N>>{
    public N and();
    public N endTraffic();
    
  }
  
}