package io.dekorate.knative.config;

import java.lang.Integer;
import java.lang.Object;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class GlobalAutoScaling{
  public GlobalAutoScaling() {
  }
  public GlobalAutoScaling(AutoScalerClass autoScalerClass,Integer containerConcurrency,Integer targetUtilizationPercentage,Integer requestsPerSecond) {
    this.autoScalerClass = autoScalerClass;
    this.containerConcurrency = containerConcurrency;
    this.targetUtilizationPercentage = targetUtilizationPercentage;
    this.requestsPerSecond = requestsPerSecond;
  }
  private AutoScalerClass autoScalerClass;
  private Integer containerConcurrency;
  private Integer targetUtilizationPercentage;
  private Integer requestsPerSecond;
  
  /**
   * The Autoscaler class.
   * Knative Serving comes with its own autoscaler, the KPA (Knative Pod Autoscaler) but can also be configured to use
   * Kubernetes’ HPA (Horizontal Pod Autoscaler) or even a custom third-party autoscaler.
   * Possible values (kpa, hpa, default: kpa).
   * @return The autoscaler class.
   */
public AutoScalerClass getAutoScalerClass() {
    return this.autoScalerClass;
  }
  
  /**
   * The exact amount of requests allowed to the replica at a time.
   * Its default value is “0”, which means an unlimited number of requests are allowed to flow into the replica.
   * @return the container concurrenct or zero if its not bound.
   */
public Integer getContainerConcurrency() {
    return this.containerConcurrency;
  }
  
  /**
   * This value specifies a percentage of the target to actually be targeted by the autoscaler.
   */
public Integer getTargetUtilizationPercentage() {
    return this.targetUtilizationPercentage;
  }
  
  /**
   * The requests per second per replica.
   */
public Integer getRequestsPerSecond() {
    return this.requestsPerSecond;
  }
  public static GlobalAutoScalingBuilder newBuilder() {
    return new GlobalAutoScalingBuilder();
  }
  public static GlobalAutoScalingBuilder newBuilderFromDefaults() {
    return new GlobalAutoScalingBuilder().withAutoScalerClass(io.dekorate.knative.config.AutoScalerClass.kpa).withContainerConcurrency(0).withTargetUtilizationPercentage(70).withRequestsPerSecond(200);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GlobalAutoScaling that = (GlobalAutoScaling) o;
    if (autoScalerClass != null ? !autoScalerClass.equals(that.autoScalerClass) :that.autoScalerClass != null) return false;
    if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
    if (targetUtilizationPercentage != null ? !targetUtilizationPercentage.equals(that.targetUtilizationPercentage) :that.targetUtilizationPercentage != null) return false;
    if (requestsPerSecond != null ? !requestsPerSecond.equals(that.requestsPerSecond) :that.requestsPerSecond != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(autoScalerClass,  containerConcurrency,  targetUtilizationPercentage,  requestsPerSecond,  super.hashCode());
  }
  
}