/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.config;

import io.dekorate.knative.config.AutoScaling;
import io.dekorate.knative.config.AutoScalingBuilder;
import io.dekorate.knative.config.AutoScalingFluentImpl;
import io.dekorate.knative.config.GlobalAutoScaling;
import io.dekorate.knative.config.GlobalAutoScalingBuilder;
import io.dekorate.knative.config.GlobalAutoScalingFluentImpl;
import io.dekorate.knative.config.HttpTransportVersion;
import io.dekorate.knative.config.KnativeConfig;
import io.dekorate.knative.config.KnativeConfigFluent;
import io.dekorate.knative.config.Traffic;
import io.dekorate.knative.config.TrafficBuilder;
import io.dekorate.knative.config.TrafficFluentImpl;
import io.dekorate.kubernetes.config.BaseConfigFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KnativeConfigFluentImpl<A extends KnativeConfigFluent<A>>
extends BaseConfigFluentImpl<A>
implements KnativeConfigFluent<A> {
    private String revisionName;
    private String host;
    private HttpTransportVersion httpTransportVersion;
    private Boolean expose;
    private Integer minScale;
    private Integer maxScale;
    private Boolean scaleToZeroEnabled;
    private AutoScalingBuilder revisionAutoScaling;
    private GlobalAutoScalingBuilder globalAutoScaling;
    private String templateName;
    private ArrayList<TrafficBuilder> traffic = new ArrayList();

    public KnativeConfigFluentImpl() {
    }

    public KnativeConfigFluentImpl(KnativeConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withDeploymentKind(instance.getDeploymentKind());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withServiceAccount(instance.getServiceAccount());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withHostAliases(instance.getHostAliases());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withStartupProbe(instance.getStartupProbe());
        this.withRequestResources(instance.getRequestResources());
        this.withLimitResources(instance.getLimitResources());
        this.withSidecars(instance.getSidecars());
        this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
        this.withJobs(instance.getJobs());
        this.withCronJobs(instance.getCronJobs());
        this.withRevisionName(instance.getRevisionName());
        this.withHost(instance.getHost());
        this.withHttpTransportVersion(instance.getHttpTransportVersion());
        this.withExpose(instance.getExpose());
        this.withMinScale(instance.getMinScale());
        this.withMaxScale(instance.getMaxScale());
        this.withScaleToZeroEnabled(instance.getScaleToZeroEnabled());
        this.withRevisionAutoScaling(instance.getRevisionAutoScaling());
        this.withGlobalAutoScaling(instance.getGlobalAutoScaling());
        this.withTemplateName(instance.getTemplateName());
        this.withTraffic(instance.getTraffic());
    }

    @Override
    public String getRevisionName() {
        return this.revisionName;
    }

    @Override
    public A withRevisionName(String revisionName) {
        this.revisionName = revisionName;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionName() {
        return this.revisionName != null;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public HttpTransportVersion getHttpTransportVersion() {
        return this.httpTransportVersion;
    }

    @Override
    public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion) {
        this.httpTransportVersion = httpTransportVersion;
        return (A)this;
    }

    @Override
    public Boolean hasHttpTransportVersion() {
        return this.httpTransportVersion != null;
    }

    @Override
    public Boolean getExpose() {
        return this.expose;
    }

    @Override
    public A withExpose(Boolean expose) {
        this.expose = expose;
        return (A)this;
    }

    @Override
    public Boolean hasExpose() {
        return this.expose != null;
    }

    @Override
    public Integer getMinScale() {
        return this.minScale;
    }

    @Override
    public A withMinScale(Integer minScale) {
        this.minScale = minScale;
        return (A)this;
    }

    @Override
    public Boolean hasMinScale() {
        return this.minScale != null;
    }

    @Override
    public Integer getMaxScale() {
        return this.maxScale;
    }

    @Override
    public A withMaxScale(Integer maxScale) {
        this.maxScale = maxScale;
        return (A)this;
    }

    @Override
    public Boolean hasMaxScale() {
        return this.maxScale != null;
    }

    @Override
    public Boolean getScaleToZeroEnabled() {
        return this.scaleToZeroEnabled;
    }

    @Override
    public A withScaleToZeroEnabled(Boolean scaleToZeroEnabled) {
        this.scaleToZeroEnabled = scaleToZeroEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasScaleToZeroEnabled() {
        return this.scaleToZeroEnabled != null;
    }

    @Override
    @Deprecated
    public AutoScaling getRevisionAutoScaling() {
        return this.revisionAutoScaling != null ? this.revisionAutoScaling.build() : null;
    }

    @Override
    public AutoScaling buildRevisionAutoScaling() {
        return this.revisionAutoScaling != null ? this.revisionAutoScaling.build() : null;
    }

    @Override
    public A withRevisionAutoScaling(AutoScaling revisionAutoScaling) {
        this._visitables.get((Object)"revisionAutoScaling").remove(this.revisionAutoScaling);
        if (revisionAutoScaling != null) {
            this.revisionAutoScaling = new AutoScalingBuilder(revisionAutoScaling);
            this._visitables.get((Object)"revisionAutoScaling").add(this.revisionAutoScaling);
        } else {
            this.revisionAutoScaling = null;
            this._visitables.get((Object)"revisionAutoScaling").remove(this.revisionAutoScaling);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRevisionAutoScaling() {
        return this.revisionAutoScaling != null;
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScaling() {
        return new RevisionAutoScalingNestedImpl();
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(AutoScaling item) {
        return new RevisionAutoScalingNestedImpl(item);
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editRevisionAutoScaling() {
        return this.withNewRevisionAutoScalingLike(this.getRevisionAutoScaling());
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling() {
        return this.withNewRevisionAutoScalingLike(this.getRevisionAutoScaling() != null ? this.getRevisionAutoScaling() : new AutoScalingBuilder().build());
    }

    @Override
    public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(AutoScaling item) {
        return this.withNewRevisionAutoScalingLike(this.getRevisionAutoScaling() != null ? this.getRevisionAutoScaling() : item);
    }

    @Override
    @Deprecated
    public GlobalAutoScaling getGlobalAutoScaling() {
        return this.globalAutoScaling != null ? this.globalAutoScaling.build() : null;
    }

    @Override
    public GlobalAutoScaling buildGlobalAutoScaling() {
        return this.globalAutoScaling != null ? this.globalAutoScaling.build() : null;
    }

    @Override
    public A withGlobalAutoScaling(GlobalAutoScaling globalAutoScaling) {
        this._visitables.get((Object)"globalAutoScaling").remove(this.globalAutoScaling);
        if (globalAutoScaling != null) {
            this.globalAutoScaling = new GlobalAutoScalingBuilder(globalAutoScaling);
            this._visitables.get((Object)"globalAutoScaling").add(this.globalAutoScaling);
        } else {
            this.globalAutoScaling = null;
            this._visitables.get((Object)"globalAutoScaling").remove(this.globalAutoScaling);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGlobalAutoScaling() {
        return this.globalAutoScaling != null;
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScaling() {
        return new GlobalAutoScalingNestedImpl();
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(GlobalAutoScaling item) {
        return new GlobalAutoScalingNestedImpl(item);
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editGlobalAutoScaling() {
        return this.withNewGlobalAutoScalingLike(this.getGlobalAutoScaling());
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling() {
        return this.withNewGlobalAutoScalingLike(this.getGlobalAutoScaling() != null ? this.getGlobalAutoScaling() : new GlobalAutoScalingBuilder().build());
    }

    @Override
    public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(GlobalAutoScaling item) {
        return this.withNewGlobalAutoScalingLike(this.getGlobalAutoScaling() != null ? this.getGlobalAutoScaling() : item);
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public A withTemplateName(String templateName) {
        this.templateName = templateName;
        return (A)this;
    }

    @Override
    public Boolean hasTemplateName() {
        return this.templateName != null;
    }

    @Override
    public A withTraffic(Traffic ... traffic) {
        if (this.traffic != null) {
            this.traffic.clear();
        }
        if (traffic != null) {
            for (Traffic item : traffic) {
                this.addToTraffic(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Traffic[] getTraffic() {
        int size = this.traffic != null ? this.traffic.size() : 0;
        Traffic[] result = new Traffic[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.traffic) {
            result[index++] = (Traffic)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Traffic[] buildTraffic() {
        int size = this.traffic != null ? this.traffic.size() : 0;
        Traffic[] result = new Traffic[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.traffic) {
            result[index++] = (Traffic)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Traffic buildTraffic(Integer index) {
        return this.traffic.get(index).build();
    }

    @Override
    public Traffic buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    @Override
    public Traffic buildLastTraffic() {
        return this.traffic.get(this.traffic.size() - 1).build();
    }

    @Override
    public Traffic buildMatchingTraffic(Predicate<TrafficBuilder> predicate) {
        for (TrafficBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTraffic(Predicate<TrafficBuilder> predicate) {
        for (TrafficBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToTraffic(Integer index, Traffic item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficBuilder builder = new TrafficBuilder(item);
        this._visitables.get((Object)"traffic").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"traffic").size(), builder);
        this.traffic.add(index >= 0 ? index.intValue() : this.traffic.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTraffic(Integer index, Traffic item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficBuilder builder = new TrafficBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"traffic").size()) {
            this._visitables.get((Object)"traffic").add(builder);
        } else {
            this._visitables.get((Object)"traffic").set(index, builder);
        }
        if (index < 0 || index >= this.traffic.size()) {
            this.traffic.add(builder);
        } else {
            this.traffic.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTraffic(Traffic ... items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTraffic(Collection<Traffic> items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTraffic(Traffic ... items) {
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").remove(builder);
            if (this.traffic == null) continue;
            this.traffic.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTraffic(Collection<Traffic> items) {
        for (Traffic item : items) {
            TrafficBuilder builder = new TrafficBuilder(item);
            this._visitables.get((Object)"traffic").remove(builder);
            if (this.traffic == null) continue;
            this.traffic.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTraffic(Predicate<TrafficBuilder> predicate) {
        if (this.traffic == null) {
            return (A)this;
        }
        Iterator<TrafficBuilder> each = this.traffic.iterator();
        List visitables = this._visitables.get((Object)"traffic");
        while (each.hasNext()) {
            TrafficBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasTraffic() {
        return this.traffic != null && !this.traffic.isEmpty();
    }

    @Override
    public A addNewTraffic(String tag, String revisionName, Boolean latestRevision, Integer percentage) {
        return this.addToTraffic(new Traffic(tag, revisionName, latestRevision, percentage));
    }

    @Override
    public KnativeConfigFluent.TrafficNested<A> addNewTraffic() {
        return new TrafficNestedImpl();
    }

    @Override
    public KnativeConfigFluent.TrafficNested<A> addNewTrafficLike(Traffic item) {
        return new TrafficNestedImpl(-1, item);
    }

    @Override
    public KnativeConfigFluent.TrafficNested<A> setNewTrafficLike(Integer index, Traffic item) {
        return new TrafficNestedImpl(index, item);
    }

    @Override
    public KnativeConfigFluent.TrafficNested<A> editTraffic(Integer index) {
        if (this.traffic.size() <= index) {
            throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    @Override
    public KnativeConfigFluent.TrafficNested<A> editFirstTraffic() {
        if (this.traffic.size() == 0) {
            throw new RuntimeException("Can't edit first traffic. The list is empty.");
        }
        return this.setNewTrafficLike(0, this.buildTraffic(0));
    }

    @Override
    public KnativeConfigFluent.TrafficNested<A> editLastTraffic() {
        int index = this.traffic.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last traffic. The list is empty.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    @Override
    public KnativeConfigFluent.TrafficNested<A> editMatchingTraffic(Predicate<TrafficBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.traffic.size(); ++i) {
            if (!predicate.test(this.traffic.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching traffic. No match found.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnativeConfigFluentImpl that = (KnativeConfigFluentImpl)o;
        if (this.revisionName != null ? !this.revisionName.equals(that.revisionName) : that.revisionName != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.httpTransportVersion != null ? !this.httpTransportVersion.equals((Object)that.httpTransportVersion) : that.httpTransportVersion != null) {
            return false;
        }
        if (this.expose != null ? !this.expose.equals(that.expose) : that.expose != null) {
            return false;
        }
        if (this.minScale != null ? !this.minScale.equals(that.minScale) : that.minScale != null) {
            return false;
        }
        if (this.maxScale != null ? !this.maxScale.equals(that.maxScale) : that.maxScale != null) {
            return false;
        }
        if (this.scaleToZeroEnabled != null ? !this.scaleToZeroEnabled.equals(that.scaleToZeroEnabled) : that.scaleToZeroEnabled != null) {
            return false;
        }
        if (this.revisionAutoScaling != null ? !this.revisionAutoScaling.equals(that.revisionAutoScaling) : that.revisionAutoScaling != null) {
            return false;
        }
        if (this.globalAutoScaling != null ? !this.globalAutoScaling.equals(that.globalAutoScaling) : that.globalAutoScaling != null) {
            return false;
        }
        if (this.templateName != null ? !this.templateName.equals(that.templateName) : that.templateName != null) {
            return false;
        }
        return !(this.traffic != null ? !this.traffic.equals(that.traffic) : that.traffic != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.revisionName, this.host, this.httpTransportVersion, this.expose, this.minScale, this.maxScale, this.scaleToZeroEnabled, this.revisionAutoScaling, this.globalAutoScaling, this.templateName, this.traffic, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.revisionName != null) {
            sb.append("revisionName:");
            sb.append(this.revisionName + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpTransportVersion != null) {
            sb.append("httpTransportVersion:");
            sb.append((Object)((Object)this.httpTransportVersion) + ",");
        }
        if (this.expose != null) {
            sb.append("expose:");
            sb.append(this.expose + ",");
        }
        if (this.minScale != null) {
            sb.append("minScale:");
            sb.append(this.minScale + ",");
        }
        if (this.maxScale != null) {
            sb.append("maxScale:");
            sb.append(this.maxScale + ",");
        }
        if (this.scaleToZeroEnabled != null) {
            sb.append("scaleToZeroEnabled:");
            sb.append(this.scaleToZeroEnabled + ",");
        }
        if (this.revisionAutoScaling != null) {
            sb.append("revisionAutoScaling:");
            sb.append(this.revisionAutoScaling + ",");
        }
        if (this.globalAutoScaling != null) {
            sb.append("globalAutoScaling:");
            sb.append(this.globalAutoScaling + ",");
        }
        if (this.templateName != null) {
            sb.append("templateName:");
            sb.append(this.templateName + ",");
        }
        if (this.traffic != null && !this.traffic.isEmpty()) {
            sb.append("traffic:");
            sb.append(this.traffic);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withExpose() {
        return this.withExpose(true);
    }

    @Override
    public A withScaleToZeroEnabled() {
        return this.withScaleToZeroEnabled(true);
    }

    class TrafficNestedImpl<N>
    extends TrafficFluentImpl<KnativeConfigFluent.TrafficNested<N>>
    implements KnativeConfigFluent.TrafficNested<N>,
    Nested<N> {
        TrafficBuilder builder;
        Integer index;

        TrafficNestedImpl(Integer index, Traffic item) {
            this.index = index;
            this.builder = new TrafficBuilder(this, item);
        }

        TrafficNestedImpl() {
            this.index = -1;
            this.builder = new TrafficBuilder(this);
        }

        @Override
        public N and() {
            return (N)KnativeConfigFluentImpl.this.setToTraffic(this.index, this.builder.build());
        }

        @Override
        public N endTraffic() {
            return this.and();
        }
    }

    class GlobalAutoScalingNestedImpl<N>
    extends GlobalAutoScalingFluentImpl<KnativeConfigFluent.GlobalAutoScalingNested<N>>
    implements KnativeConfigFluent.GlobalAutoScalingNested<N>,
    Nested<N> {
        GlobalAutoScalingBuilder builder;

        GlobalAutoScalingNestedImpl(GlobalAutoScaling item) {
            this.builder = new GlobalAutoScalingBuilder(this, item);
        }

        GlobalAutoScalingNestedImpl() {
            this.builder = new GlobalAutoScalingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KnativeConfigFluentImpl.this.withGlobalAutoScaling(this.builder.build());
        }

        @Override
        public N endGlobalAutoScaling() {
            return this.and();
        }
    }

    class RevisionAutoScalingNestedImpl<N>
    extends AutoScalingFluentImpl<KnativeConfigFluent.RevisionAutoScalingNested<N>>
    implements KnativeConfigFluent.RevisionAutoScalingNested<N>,
    Nested<N> {
        AutoScalingBuilder builder;

        RevisionAutoScalingNestedImpl(AutoScaling item) {
            this.builder = new AutoScalingBuilder(this, item);
        }

        RevisionAutoScalingNestedImpl() {
            this.builder = new AutoScalingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KnativeConfigFluentImpl.this.withRevisionAutoScaling(this.builder.build());
        }

        @Override
        public N endRevisionAutoScaling() {
            return this.and();
        }
    }
}

