/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.sink.naming;

import io.debezium.sink.DebeziumSinkRecord;
import io.debezium.sink.naming.CollectionNamingStrategy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCollectionNamingStrategy
implements CollectionNamingStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCollectionNamingStrategy.class);
    private static final String ENVELOPE_SOURCE_FIELD_NAME = "source";
    private final Pattern sourcePattern = Pattern.compile("\\$\\{(source\\.)(.*?)}");

    @Override
    public String resolveCollectionName(DebeziumSinkRecord record, String collectionNameFormat) {
        String topicName = record.topicName().replace(".", "_");
        String collection = collectionNameFormat.replace("${topic}", topicName);
        collection = this.resolveCollectionNameBySource(record, collection, collectionNameFormat);
        return collection;
    }

    private String resolveCollectionNameBySource(DebeziumSinkRecord record, String collectionName, String collectionNameFormat) {
        if (collectionName.contains("${source.")) {
            if (!record.isDebeziumMessage()) {
                LOGGER.warn("Ignore this record because it isn't a Debezium record, then cannot resolve a collection name in topic '{}', partition '{}', offset '{}'", new Object[]{record.topicName(), record.partition(), record.offset()});
                return null;
            }
            try {
                Struct source = ((Struct)record.value()).getStruct(ENVELOPE_SOURCE_FIELD_NAME);
                Matcher matcher = this.sourcePattern.matcher(collectionName);
                while (matcher.find()) {
                    String target = matcher.group();
                    collectionName = collectionName.replace(target, source.getString(matcher.group(2)));
                }
            }
            catch (DataException e) {
                LOGGER.error("Failed to resolve collection name with format '{}', check source field in topic '{}'", new Object[]{collectionNameFormat, record.topicName(), e});
                throw e;
            }
        }
        return collectionName;
    }
}

