/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import io.debezium.connector.common.DebeziumTaskState;
import io.debezium.openlineage.ConnectorContext;
import io.debezium.openlineage.dataset.DatasetMetadata;
import io.debezium.openlineage.emitter.LineageEmitter;
import io.debezium.openlineage.emitter.LineageEmitterFactory;
import io.debezium.openlineage.emitter.NoOpLineageEmitter;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumOpenLineageEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumOpenLineageEmitter.class);
    private static final ServiceLoader<LineageEmitterFactory> lineageEmitterFactory = ServiceLoader.load(LineageEmitterFactory.class);
    private static final Object SERVICE_LOADER_LOCK = new Object();
    private static final ConcurrentHashMap<String, LineageEmitter> emitters = new ConcurrentHashMap();
    private static volatile NoOpLineageEmitter noOpLineageEmitter;

    public static void emit(ConnectorContext connectorContext, DebeziumTaskState state) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state);
    }

    public static void emit(ConnectorContext connectorContext, DebeziumTaskState state, Throwable t) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state, List.of(), t);
    }

    public static void emit(ConnectorContext connectorContext, DebeziumTaskState state, List<DatasetMetadata> datasetMetadata) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state, datasetMetadata);
    }

    public static void emit(ConnectorContext connectorContext, DebeziumTaskState state, List<DatasetMetadata> datasetMetadata, Throwable t) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).emit(state, datasetMetadata, t);
    }

    public static ConnectorContext connectorContext(Map<String, String> config, String connectorName, UUID runId) {
        return ConnectorContext.from(config, connectorName, runId);
    }

    public static void cleanup(ConnectorContext connectorContext) {
        DebeziumOpenLineageEmitter.getEmitter(connectorContext).close();
        LineageEmitter removed = emitters.remove(connectorContext.toEmitterKey());
        if (removed != null) {
            LOGGER.debug("Cleaned up emitter for connector {}", (Object)connectorContext);
        }
    }

    private static LineageEmitter getEmitter(ConnectorContext connectorContext) {
        if (DebeziumOpenLineageEmitter.isOpenLineageDisabled(connectorContext)) {
            return DebeziumOpenLineageEmitter.getNoOpLineageEmitter();
        }
        LineageEmitter emitter = emitters.get(connectorContext.toEmitterKey());
        LOGGER.debug("Available emitters {}", emitters);
        if (emitter == null) {
            return DebeziumOpenLineageEmitter.init(connectorContext);
        }
        return emitter;
    }

    private static LineageEmitter init(ConnectorContext connectorContext) {
        LOGGER.debug("Calling init for connector with context {}", (Object)connectorContext);
        LineageEmitter emitter = emitters.computeIfAbsent(connectorContext.toEmitterKey(), key -> {
            LOGGER.debug("Creating new emitter for connector with name {}", key);
            Object object = SERVICE_LOADER_LOCK;
            synchronized (object) {
                return lineageEmitterFactory.stream().findFirst().map(ServiceLoader.Provider::get).orElse(ignore -> new NoOpLineageEmitter()).get(connectorContext);
            }
        });
        LOGGER.debug("Emitter instance for connector {}: {}", (Object)connectorContext.connectorName(), (Object)emitter);
        return emitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NoOpLineageEmitter getNoOpLineageEmitter() {
        if (noOpLineageEmitter != null) return noOpLineageEmitter;
        Class<DebeziumOpenLineageEmitter> clazz = DebeziumOpenLineageEmitter.class;
        synchronized (DebeziumOpenLineageEmitter.class) {
            if (noOpLineageEmitter != null) return noOpLineageEmitter;
            noOpLineageEmitter = new NoOpLineageEmitter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return noOpLineageEmitter;
        }
    }

    private static boolean isOpenLineageDisabled(ConnectorContext connectorContext) {
        return connectorContext.config() != null && !Boolean.parseBoolean(connectorContext.config().get("openlineage.integration.enabled"));
    }
}

