/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.embedded.async.AbstractRecordProcessor;
import io.debezium.embedded.async.ProcessingCallables;
import io.debezium.engine.DebeziumEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSmtAndConvertBatchProcessor<R>
extends AbstractRecordProcessor<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelSmtAndConvertBatchProcessor.class);
    final DebeziumEngine.RecordCommitter committer;
    final DebeziumEngine.ChangeConsumer<R> userHandler;
    final Function<SourceRecord, R> convertor;

    ParallelSmtAndConvertBatchProcessor(DebeziumEngine.RecordCommitter committer, DebeziumEngine.ChangeConsumer<R> userHandler, Function<SourceRecord, R> convertor) {
        this.committer = committer;
        this.userHandler = userHandler;
        this.convertor = convertor;
    }

    @Override
    public void processRecords(List<SourceRecord> records) throws Exception {
        LOGGER.debug("Thread {} is submitting {} records for processing.", (Object)Thread.currentThread().getName(), (Object)records.size());
        ArrayList recordFutures = new ArrayList(records.size());
        records.stream().forEachOrdered(r -> recordFutures.add(this.recordService.submit(new ProcessingCallables.TransformAndConvertRecord<R>((SourceRecord)r, this.transformations, this.convertor))));
        LOGGER.trace("Getting source records.");
        ArrayList convertedRecords = new ArrayList(recordFutures.size());
        for (Future f : recordFutures) {
            Object record = f.get();
            if (record == null) continue;
            convertedRecords.add(record);
        }
        LOGGER.trace("Calling user handler.");
        this.userHandler.handleBatch(convertedRecords, this.committer);
    }
}

