/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.common.UUIDUtils;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.util.Map;
import java.util.UUID;

public class CdcSourceTaskContext<T extends CommonConnectorConfig> {
    private final String connectorType;
    private final String connectorLogicalName;
    private final String connectorPluginName;
    private final String taskId;
    private final Map<String, String> customMetricTags;
    private final Clock clock;
    private final T connectorConfig;
    private final Configuration rawConfig;
    private final UUID runId;

    public CdcSourceTaskContext(Configuration rawConfig, T connectorConfig, String taskId, Map<String, String> customMetricTags) {
        this.connectorType = ((CommonConnectorConfig)connectorConfig).getContextName();
        this.connectorLogicalName = ((CommonConnectorConfig)connectorConfig).getLogicalName();
        this.connectorPluginName = ((CommonConnectorConfig)connectorConfig).getConnectorName();
        this.taskId = taskId;
        this.customMetricTags = customMetricTags;
        this.connectorConfig = connectorConfig;
        this.rawConfig = rawConfig;
        this.clock = Clock.system();
        this.runId = UUIDUtils.generateNewUUID();
    }

    public CdcSourceTaskContext(Configuration rawConfig, T connectorConfig, Map<String, String> customMetricTags) {
        this(rawConfig, connectorConfig, "0", customMetricTags);
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector(this.connectorType, this.connectorLogicalName, contextName);
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName, Partition partition) {
        return LoggingContext.forConnector(this.connectorType, this.connectorLogicalName, this.taskId, contextName, partition);
    }

    public void temporaryLoggingContext(CommonConnectorConfig connectorConfig, String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector("MySQL", connectorConfig.getLogicalName(), contextName, operation);
    }

    public Clock getClock() {
        return this.clock;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getConnectorLogicalName() {
        return this.connectorLogicalName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getConnectorPluginName() {
        return this.connectorPluginName;
    }

    public Map<String, String> getCustomMetricTags() {
        return this.customMetricTags;
    }

    public T getConfig() {
        return this.connectorConfig;
    }

    public Configuration getRawConfig() {
        return this.rawConfig;
    }

    public UUID getRunId() {
        return this.runId;
    }
}

