/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source;

import io.debezium.spi.schema.DataCollectionId;
import java.util.List;
import java.util.Map;

public class SnapshottingTask {
    private final boolean snapshotSchema;
    private final boolean snapshotData;
    private final List<String> dataCollections;
    private final Map<DataCollectionId, String> filterQueries;
    private final boolean onDemand;

    public SnapshottingTask(boolean snapshotSchema, boolean snapshotData, List<String> dataCollections, Map<DataCollectionId, String> filterQueries, boolean onDemand) {
        this.snapshotSchema = snapshotSchema;
        this.snapshotData = snapshotData;
        this.dataCollections = dataCollections;
        this.filterQueries = filterQueries;
        this.onDemand = onDemand;
    }

    public boolean snapshotData() {
        return this.snapshotData;
    }

    public boolean snapshotSchema() {
        return this.snapshotSchema;
    }

    public List<String> getDataCollections() {
        return this.dataCollections;
    }

    public Map<DataCollectionId, String> getFilterQueries() {
        return this.filterQueries;
    }

    public boolean shouldSkipSnapshot() {
        return !this.snapshotSchema() && !this.snapshotData();
    }

    public boolean isOnDemand() {
        return this.onDemand;
    }

    public String toString() {
        return "SnapshottingTask [snapshotSchema=" + this.snapshotSchema + ", snapshotData=" + this.snapshotData + "]";
    }
}

