/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.AbstractSnapshotProvider;
import io.debezium.snapshot.spi.SnapshotLock;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLockProvider
extends AbstractSnapshotProvider
implements ServiceProvider<SnapshotLock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotLockProvider.class);
    final List<SnapshotLock> snapshotLockImplementations;

    public SnapshotLockProvider() {
        this.snapshotLockImplementations = StreamSupport.stream(ServiceLoader.load(SnapshotLock.class).spliterator(), false).collect(Collectors.toList());
    }

    public SnapshotLockProvider(List<SnapshotLock> snapshotLockImplementations) {
        this.snapshotLockImplementations = snapshotLockImplementations;
    }

    @Override
    public SnapshotLock createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        Predicate<SnapshotLock> byNameAndConnectorFilter;
        Predicate<SnapshotLock> byNameFilter;
        String snapshotLockMode;
        BeanRegistry beanRegistry = serviceRegistry.tryGetService(BeanRegistry.class);
        CommonConnectorConfig commonConnectorConfig = beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class);
        String configuredSnapshotLockingMode = this.snapshotLockingMode(commonConnectorConfig);
        String snapshotLockingModeCustomName = commonConnectorConfig.snapshotLockingModeCustomName();
        if ("custom".equals(configuredSnapshotLockingMode) && !snapshotLockingModeCustomName.isEmpty()) {
            snapshotLockMode = snapshotLockingModeCustomName;
            byNameFilter = snapshotLockImplementation -> snapshotLockImplementation.name().equals(snapshotLockMode);
            byNameAndConnectorFilter = byNameFilter;
        } else {
            snapshotLockMode = configuredSnapshotLockingMode;
            byNameFilter = snapshotLockImplementation -> snapshotLockImplementation.name().equals(snapshotLockMode);
            byNameAndConnectorFilter = byNameFilter.and(snapshotLockImplementation -> this.isForCurrentConnector(configuration, snapshotLockImplementation.getClass()));
        }
        Optional<SnapshotLock> snapshotLock = this.snapshotLockImplementations.stream().filter(byNameAndConnectorFilter).findAny();
        if (snapshotLock.isEmpty()) {
            snapshotLock = this.snapshotLockImplementations.stream().filter(byNameFilter).findAny();
            snapshotLock.ifPresent(lockImpl -> LOGGER.warn("Found a not connector specific implementation {} for lock mode {}", (Object)lockImpl.getClass().getName(), (Object)snapshotLockMode));
        }
        return snapshotLock.map(snapshotLockImpl -> {
            snapshotLockImpl.configure(configuration.asMap());
            if (snapshotLockImpl instanceof BeanRegistryAware) {
                ((BeanRegistryAware)((Object)snapshotLockImpl)).injectBeanRegistry(beanRegistry);
            }
            return snapshotLockImpl;
        }).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshot lock mode. Please check your configuration.", snapshotLockMode)));
    }

    @Override
    public Class<SnapshotLock> getServiceClass() {
        return SnapshotLock.class;
    }

    public String snapshotLockingMode(CommonConnectorConfig configuration) {
        if (configuration.getSnapshotLockingMode().isEmpty()) {
            return "no_locking_support";
        }
        return configuration.getSnapshotLockingMode().get().getValue();
    }
}

