/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data.vector;

import io.debezium.data.vector.Vectors;
import io.debezium.schema.SchemaFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatVector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FloatVector.class);
    public static final String LOGICAL_NAME = "io.debezium.data.FloatVector";
    public static int SCHEMA_VERSION = 1;

    public static SchemaBuilder builder() {
        return SchemaFactory.get().datatypeFloatVectorSchema();
    }

    public static Schema schema() {
        return FloatVector.builder().build();
    }

    public static List<Float> fromLogical(Schema schema, String value) {
        return Vectors.fromVectorString(schema, value, Float::parseFloat);
    }

    public static List<Float> fromLogical(Schema schema, float[] value) {
        ArrayList<Float> ret = new ArrayList<Float>(value.length);
        for (float v : value) {
            ret.add(Float.valueOf(v));
        }
        return ret;
    }

    public static List<Float> fromLogical(Field fieldDfn, byte[] value) {
        if (value.length % 4 != 0) {
            LOGGER.warn("Cannot convert field '{}', the octet stream is not multiply of {}", (Object)fieldDfn.name(), (Object)4);
            return Collections.emptyList();
        }
        ArrayList<Float> ret = new ArrayList<Float>(value.length);
        int i = 0;
        while (i < value.length) {
            int intValue = value[i++] & 0xFF | (value[i++] & 0xFF) << 8 | (value[i++] & 0xFF) << 16 | (value[i++] & 0xFF) << 24;
            ret.add(Float.valueOf(Float.intBitsToFloat(intValue)));
        }
        return ret;
    }
}

