/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.transforms.SmtManager;
import io.debezium.util.BoundedConcurrentHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderToValue<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderToValue.class);
    public static final String FIELDS_CONF = "fields";
    public static final String HEADERS_CONF = "headers";
    public static final String OPERATION_CONF = "operation";
    private static final String MOVE_OPERATION = "move";
    private static final String COPY_OPERATION = "copy";
    private static final int CACHE_SIZE = 64;
    public static final String NESTING_SEPARATOR = ".";
    public static final String ROOT_FIELD_NAME = "payload";
    public static final Field HEADERS_FIELD = Field.create("headers").withDisplayName("Header names list").withType(ConfigDef.Type.LIST).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::notContainSpaceInAnyElement, Field::notContainEmptyElements).withDescription("Header names in the record whose values are to be copied or moved to record value.").required();
    public static final Field FIELDS_FIELD = Field.create("fields").withDisplayName("Field names list").withType(ConfigDef.Type.LIST).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::notContainSpaceInAnyElement, Field::notContainEmptyElements).withDescription("Field names, in the same order as the header names listed in the headers configuration property. Supports Struct nesting using dot notation.").required();
    public static final Field OPERATION_FIELD = Field.create("operation").withDisplayName("Operation: mover or copy").withType(ConfigDef.Type.STRING).withEnum(Operation.class).withImportance(ConfigDef.Importance.HIGH).withDescription("Either <code>move</code> if the fields are to be moved to the value (removed from the headers), or <code>copy</code> if the fields are to be copied to the value (retained in the headers).").required();
    private List<String> fields;
    private List<String> headers;
    private Operation operation;
    private final BoundedConcurrentHashMap<Schema, Schema> schemaUpdateCache = new BoundedConcurrentHashMap(64);
    private final BoundedConcurrentHashMap<Headers, Headers> headersUpdateCache = new BoundedConcurrentHashMap(64);

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, HEADERS_FIELD, FIELDS_FIELD, OPERATION_FIELD);
        return config;
    }

    public void configure(Map<String, ?> props) {
        Configuration config = Configuration.from(props);
        SmtManager smtManager = new SmtManager(config);
        smtManager.validate(config, Field.setOf(FIELDS_FIELD, HEADERS_FIELD, OPERATION_FIELD));
        this.fields = config.getList(FIELDS_FIELD);
        this.headers = config.getList(HEADERS_FIELD);
        this.validateConfiguration();
        this.operation = Operation.fromName(config.getString(OPERATION_FIELD));
    }

    private void validateConfiguration() {
        if (this.headers.size() != this.fields.size()) {
            throw new ConfigException(String.format("'%s' config must have the same number of elements as '%s' config.", FIELDS_FIELD, HEADERS_FIELD));
        }
    }

    public R apply(R record) {
        if (record.value() == null) {
            LOGGER.trace("Tombstone {} arrived and will be skipped", record.key());
            return record;
        }
        Struct value = Requirements.requireStruct((Object)record.value(), (String)"Header field insertion");
        LOGGER.trace("Processing record {}", (Object)value);
        Map<String, Header> headerToProcess = StreamSupport.stream(record.headers().spliterator(), false).filter(header -> this.headers.contains(header.key())).collect(Collectors.toMap(Header::key, Function.identity()));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Header to be processed: {}", (Object)this.headersToString(headerToProcess));
        }
        if (headerToProcess.isEmpty()) {
            return record;
        }
        Schema updatedSchema = this.schemaUpdateCache.computeIfAbsent(value.schema(), valueSchema -> this.makeNewSchema((Schema)valueSchema, headerToProcess));
        LOGGER.trace("Updated schema fields: {}", (Object)updatedSchema.fields());
        Struct updatedValue = this.makeUpdatedValue(value, headerToProcess, updatedSchema);
        LOGGER.trace("Updated value: {}", (Object)updatedValue);
        Headers updatedHeaders = record.headers();
        if (Operation.MOVE.equals((Object)this.operation)) {
            updatedHeaders = this.headersUpdateCache.computeIfAbsent(record.headers(), this::removeHeaders);
        }
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, (Object)updatedValue, record.timestamp(), (Iterable)updatedHeaders);
    }

    private Headers removeHeaders(Headers originalHeaders) {
        Headers updatedHeaders = originalHeaders.duplicate();
        this.headers.forEach(arg_0 -> ((Headers)updatedHeaders).remove(arg_0));
        return updatedHeaders;
    }

    private Struct makeUpdatedValue(Struct originalValue, Map<String, Header> headerToProcess, Schema updatedSchema) {
        List<String> nestedFields = this.fields.stream().filter(field -> field.contains(NESTING_SEPARATOR)).collect(Collectors.toList());
        return this.buildUpdatedValue(ROOT_FIELD_NAME, originalValue, headerToProcess, updatedSchema, nestedFields, 0);
    }

    private Struct buildUpdatedValue(String fieldName, Struct originalValue, Map<String, Header> headerToProcess, Schema updatedSchema, List<String> nestedFields, int level) {
        Struct updatedValue = new Struct(updatedSchema);
        for (org.apache.kafka.connect.data.Field field : originalValue.schema().fields()) {
            if (originalValue.get(field) == null) continue;
            if (this.isContainedIn(field.name(), nestedFields)) {
                Struct nestedField = Requirements.requireStruct((Object)originalValue.get(field), (String)"Nested field");
                updatedValue.put(field.name(), (Object)this.buildUpdatedValue(field.name(), nestedField, headerToProcess, updatedSchema.field(field.name()).schema(), nestedFields, ++level));
                continue;
            }
            updatedValue.put(field.name(), originalValue.get(field));
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            Header currentHeader = headerToProcess.get(this.headers.get(i));
            if (currentHeader == null) continue;
            Optional<String> fieldNameToAdd = this.getFieldName(this.fields.get(i), fieldName, level);
            fieldNameToAdd.ifPresent(s -> updatedValue.put(s, currentHeader.value()));
        }
        return updatedValue;
    }

    private boolean isContainedIn(String fieldName, List<String> nestedFields) {
        return nestedFields.stream().anyMatch(s -> s.contains(fieldName));
    }

    private Schema makeNewSchema(Schema oldSchema, Map<String, Header> headerToProcess) {
        List<String> nestedFields = this.fields.stream().filter(field -> field.contains(NESTING_SEPARATOR)).collect(Collectors.toList());
        return this.buildNewSchema(ROOT_FIELD_NAME, oldSchema, headerToProcess, nestedFields, 0);
    }

    private Schema buildNewSchema(String fieldName, Schema oldSchema, Map<String, Header> headerToProcess, List<String> nestedFields, int level) {
        if (oldSchema.type().isPrimitive()) {
            return oldSchema;
        }
        SchemaBuilder newSchemabuilder = SchemaUtil.copySchemaBasics((Schema)oldSchema, (SchemaBuilder)SchemaBuilder.struct());
        for (org.apache.kafka.connect.data.Field field : oldSchema.fields()) {
            if (this.isContainedIn(field.name(), nestedFields)) {
                newSchemabuilder.field(field.name(), this.buildNewSchema(field.name(), field.schema(), headerToProcess, nestedFields, ++level));
                continue;
            }
            newSchemabuilder.field(field.name(), field.schema());
        }
        LOGGER.debug("Fields copied from the old schema {}", (Object)newSchemabuilder.fields());
        for (int i = 0; i < this.headers.size(); ++i) {
            Header currentHeader = headerToProcess.get(this.headers.get(i));
            Optional<String> currentFieldName = this.getFieldName(this.fields.get(i), fieldName, level);
            LOGGER.trace("CurrentHeader {} - currentFieldName {}", (Object)this.headers.get(i), currentFieldName);
            if (!currentFieldName.isPresent() || currentHeader == null) continue;
            newSchemabuilder = newSchemabuilder.field(currentFieldName.get(), currentHeader.schema());
        }
        LOGGER.debug("Fields added from headers {}", (Object)newSchemabuilder.fields());
        return newSchemabuilder.build();
    }

    private Optional<String> getFieldName(String destinationFieldName, String fieldName, int level) {
        String[] nestedNames = destinationFieldName.split("\\.");
        if (HeaderToValue.isRootField(fieldName, nestedNames)) {
            return Optional.of(nestedNames[0]);
        }
        if (HeaderToValue.isChildrenOf(fieldName, level, nestedNames)) {
            return Optional.of(nestedNames[level]);
        }
        return Optional.empty();
    }

    private static boolean isChildrenOf(String fieldName, int level, String[] nestedNames) {
        int parentLevel = level == 0 ? 0 : level - 1;
        return nestedNames[parentLevel].equals(fieldName);
    }

    private static boolean isRootField(String fieldName, String[] nestedNames) {
        return nestedNames.length == 1 && fieldName.equals(ROOT_FIELD_NAME);
    }

    private String headersToString(Map<?, ?> map) {
        return map.keySet().stream().map(key -> key + "=" + map.get(key)).collect(Collectors.joining(", ", "{", "}"));
    }

    public void close() {
    }

    public String version() {
        return Module.version();
    }

    static enum Operation {
        MOVE("move"),
        COPY("copy");

        private final String name;

        private Operation(String name) {
            this.name = name;
        }

        static Operation fromName(String name) {
            switch (name) {
                case "move": {
                    return MOVE;
                }
                case "copy": {
                    return COPY;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.name;
        }
    }
}

