/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableChanges
implements Iterable<TableChange> {
    private final List<TableChange> changes = new ArrayList<TableChange>();

    public TableChanges create(Table table) {
        this.changes.add(new TableChange(TableChangeType.CREATE, table));
        return this;
    }

    public TableChanges alter(Table table) {
        this.changes.add(new TableChange(TableChangeType.ALTER, table));
        return this;
    }

    public TableChanges alter(TableChange change) {
        if (change.getPreviousId() == null) {
            return this.alter(change.getTable());
        }
        return this.rename(change.getTable(), change.getPreviousId());
    }

    public TableChanges rename(Table table, TableId previousId) {
        this.changes.add(new TableChange(TableChangeType.ALTER, table, previousId));
        return this;
    }

    public TableChanges drop(TableId id) {
        this.changes.add(new TableChange(TableChangeType.DROP, id));
        return this;
    }

    @Override
    public Iterator<TableChange> iterator() {
        return this.changes.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.changes.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableChanges other = (TableChanges)obj;
        return this.changes.equals(other.changes);
    }

    public String toString() {
        return "TableChanges [changes=" + this.changes + "]";
    }

    public static class TableChange {
        private final TableChangeType type;
        private final TableId previousId;
        private final TableId id;
        private final Table table;

        public TableChange(TableChangeType type, Table table) {
            this(type, table, null);
        }

        public TableChange(TableChangeType type, TableId id) {
            this.type = type;
            this.id = id;
            this.table = null;
            this.previousId = null;
        }

        public TableChange(TableChangeType type, Table table, TableId previousId) {
            this.type = type;
            this.table = table;
            this.id = table.id();
            this.previousId = previousId;
        }

        public TableChangeType getType() {
            return this.type;
        }

        public TableId getId() {
            return this.id;
        }

        public TableId getPreviousId() {
            return this.previousId;
        }

        public Table getTable() {
            return this.table;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            result = 31 * result + (this.previousId == null ? 0 : this.previousId.hashCode());
            result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableChange other = (TableChange)obj;
            if (!this.id.equals(other.id)) {
                return false;
            }
            if (this.previousId == null ? other.previousId != null : !this.previousId.equals(other.previousId)) {
                return false;
            }
            if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "TableChange [type=" + this.type + ", id=" + this.id + ", previousId=" + this.previousId + ", table=" + this.table + "]";
        }
    }

    public static enum TableChangeType {
        CREATE,
        ALTER,
        DROP;

    }

    public static interface TableChangesSerializer<T> {
        public T serialize(TableChanges var1);

        public TableChanges deserialize(T var1, boolean var2);
    }
}

