/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.base;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.ConfigurationDefaults;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.time.Temporals;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.ObjectSizeCalculator;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ChangeEventQueue<T>
implements ChangeEventQueueMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeEventQueue.class);
    private final Duration pollInterval;
    private final int maxBatchSize;
    private final int maxQueueSize;
    private final long maxQueueSizeInBytes;
    private final Queue<T> queue;
    private final Supplier<LoggingContext.PreviousContext> loggingContextSupplier;
    private final Queue<Long> sizeInBytesQueue;
    private long currentQueueSizeInBytes = 0L;
    private boolean buffering;
    private T bufferedEvent;
    private volatile RuntimeException producerException;

    private ChangeEventQueue(Duration pollInterval, int maxQueueSize, int maxBatchSize, Supplier<LoggingContext.PreviousContext> loggingContextSupplier, long maxQueueSizeInBytes, boolean buffering) {
        this.pollInterval = pollInterval;
        this.maxBatchSize = maxBatchSize;
        this.maxQueueSize = maxQueueSize;
        this.queue = new ArrayDeque<T>(maxQueueSize);
        this.loggingContextSupplier = loggingContextSupplier;
        this.sizeInBytesQueue = new ArrayDeque<Long>(maxQueueSize);
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
        this.buffering = buffering;
    }

    public void enqueue(T record) throws InterruptedException {
        if (record == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.buffering) {
            T newEvent = record;
            record = this.bufferedEvent;
            this.bufferedEvent = newEvent;
            if (record == null) {
                return;
            }
        }
        this.doEnqueue(record);
    }

    public void flushBuffer(Function<T, T> recordModifier) throws InterruptedException {
        assert (this.buffering) : "Unsuported for queues with disabled buffering";
        if (this.bufferedEvent != null) {
            this.doEnqueue(recordModifier.apply(this.bufferedEvent));
            this.bufferedEvent = null;
        }
    }

    public void disableBuffering() {
        assert (this.bufferedEvent == null) : "Buffer must be flushed";
        this.buffering = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEnqueue(T record) throws InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Enqueuing source record '{}'", record);
        }
        ChangeEventQueue changeEventQueue = this;
        synchronized (changeEventQueue) {
            while (this.queue.size() >= this.maxQueueSize || this.maxQueueSizeInBytes > 0L && this.currentQueueSizeInBytes >= this.maxQueueSizeInBytes) {
                this.notifyAll();
                this.wait(this.pollInterval.toMillis());
            }
            this.queue.add(record);
            if (this.maxQueueSizeInBytes > 0L) {
                long messageSize = ObjectSizeCalculator.getObjectSize(record);
                this.sizeInBytesQueue.add(messageSize);
                this.currentQueueSizeInBytes += messageSize;
            }
            if (this.queue.size() >= this.maxBatchSize || this.maxQueueSizeInBytes > 0L && this.currentQueueSizeInBytes >= this.maxQueueSizeInBytes) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> poll() throws InterruptedException {
        LoggingContext.PreviousContext previousContext = this.loggingContextSupplier.get();
        try {
            LOGGER.debug("polling records...");
            Threads.Timer timeout = Threads.timer(Clock.SYSTEM, Temporals.min(this.pollInterval, ConfigurationDefaults.RETURN_CONTROL_INTERVAL));
            ChangeEventQueue changeEventQueue = this;
            synchronized (changeEventQueue) {
                ArrayList records = new ArrayList(Math.min(this.maxBatchSize, this.queue.size()));
                while (!(this.drainRecords(records, this.maxBatchSize - records.size()) >= (long)this.maxBatchSize || this.maxQueueSizeInBytes != 0L && this.currentQueueSizeInBytes >= this.maxQueueSizeInBytes || timeout.expired())) {
                    this.throwProducerExceptionIfPresent();
                    LOGGER.debug("no records available yet, sleeping a bit...");
                    long remainingTimeoutMills = timeout.remaining().toMillis();
                    if (remainingTimeoutMills > 0L) {
                        this.notify();
                        this.wait(remainingTimeoutMills);
                    }
                    LOGGER.debug("checking for more records...");
                }
                this.notify();
                ArrayList arrayList = records;
                return arrayList;
            }
        }
        finally {
            previousContext.restore();
        }
    }

    private long drainRecords(List<T> records, int maxElements) {
        int i;
        int queueSize = this.queue.size();
        if (queueSize == 0) {
            return records.size();
        }
        int recordsToDrain = Math.min(queueSize, maxElements);
        Object[] drainedRecords = new Object[recordsToDrain];
        for (i = 0; i < recordsToDrain; ++i) {
            T record = this.queue.poll();
            drainedRecords[i] = record;
        }
        if (this.maxQueueSizeInBytes > 0L) {
            for (i = 0; i < recordsToDrain; ++i) {
                long objectSize = this.sizeInBytesQueue.poll();
                this.currentQueueSizeInBytes -= objectSize;
            }
        }
        records.addAll(Arrays.asList(drainedRecords));
        return records.size();
    }

    public void producerException(RuntimeException producerException) {
        this.producerException = producerException;
    }

    private void throwProducerExceptionIfPresent() {
        if (this.producerException != null) {
            throw this.producerException;
        }
    }

    @Override
    public int totalCapacity() {
        return this.maxQueueSize;
    }

    @Override
    public int remainingCapacity() {
        return this.maxQueueSize - this.queue.size();
    }

    @Override
    public long maxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    @Override
    public long currentQueueSizeInBytes() {
        return this.currentQueueSizeInBytes;
    }

    public static class Builder<T> {
        private Duration pollInterval;
        private int maxQueueSize;
        private int maxBatchSize;
        private Supplier<LoggingContext.PreviousContext> loggingContextSupplier;
        private long maxQueueSizeInBytes;
        private boolean buffering;

        public Builder<T> pollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        public Builder<T> maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder<T> maxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder<T> loggingContextSupplier(Supplier<LoggingContext.PreviousContext> loggingContextSupplier) {
            this.loggingContextSupplier = loggingContextSupplier;
            return this;
        }

        public Builder<T> maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            this.maxQueueSizeInBytes = maxQueueSizeInBytes;
            return this;
        }

        public Builder<T> buffering() {
            this.buffering = true;
            return this;
        }

        public ChangeEventQueue<T> build() {
            return new ChangeEventQueue(this.pollInterval, this.maxQueueSize, this.maxBatchSize, this.loggingContextSupplier, this.maxQueueSizeInBytes, this.buffering);
        }
    }
}

