/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.Testing;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class TestingTest
implements Testing {
    @Test
    public void shouldKnowDirectoriesInsideTestData() {
        Assertions.assertThat((boolean)Testing.Files.inTestDataDir(Paths.get(Testing.Files.dataDir(), "somefile"))).isTrue();
        Assertions.assertThat((boolean)Testing.Files.inTestDataDir(new File("../debezium").toPath())).isFalse();
    }

    @Test
    public void shouldRemoveDirectory() throws Exception {
        Path path = Paths.get(Testing.Files.dataDir(), "test-dir");
        Assertions.assertThat((boolean)path.toFile().mkdirs()).isTrue();
        Path file = path.resolve("file.txt");
        Assertions.assertThat((boolean)file.toFile().createNewFile()).isTrue();
        Testing.Files.delete(path);
        Assertions.assertThat((boolean)Files.exists(path, new LinkOption[0])).isFalse();
    }
}

