/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.config.Configuration;
import io.debezium.doc.FixFor;
import io.debezium.junit.relational.TestRelationalDatabaseConfig;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.relational.mapping.ColumnMappers;
import io.debezium.util.Strings;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ColumnMappersTest {
    private final TableId tableId = new TableId("db", null, "A");
    private Column column;
    private Column column2;
    private Column column3;
    private ColumnMappers mappers;
    private ValueConverter converter;
    private String fullyQualifiedNames;

    @Before
    public void beforeEach() {
        this.column = Column.editor().name("firstName").jdbcType(12).type("VARCHAR").position(1).create();
        this.column2 = Column.editor().name("lastName").jdbcType(12).type("VARCHAR").position(2).create();
        this.column3 = Column.editor().name("otherColumn").jdbcType(12).type("VARCHAR").position(3).create();
        this.fullyQualifiedNames = this.tableId + "." + this.column.name() + "," + this.tableId + "." + this.column3.name() + ",";
    }

    @Test
    public void shouldNotFindMapperForUnmatchedColumn() {
        Configuration config = Configuration.create().with("column.truncate.to.10.chars", this.fullyQualifiedNames).build();
        this.mappers = ColumnMappers.create((RelationalDatabaseConnectorConfig)new TestRelationalDatabaseConfig(config, "test", null, null, 0));
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column2);
        Assertions.assertThat((Object)this.converter).isNull();
    }

    @Test
    public void shouldTruncateStrings() {
        Configuration config = Configuration.create().with("column.truncate.to.10.chars", this.fullyQualifiedNames.toUpperCase()).build();
        this.mappers = ColumnMappers.create((RelationalDatabaseConnectorConfig)new TestRelationalDatabaseConfig(config, "test", null, null, 0));
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((String)this.converter.convert((Object)"12345678901234567890").toString()).isEqualTo((Object)"1234567890");
        Assertions.assertThat((int)this.converter.convert((Object)"12345678901234567890").toString().length()).isEqualTo(10);
        Assertions.assertThat((String)this.converter.convert((Object)"12345678901").toString()).isEqualTo((Object)"1234567890");
        Assertions.assertThat((int)this.converter.convert((Object)"12345678901").toString().length()).isEqualTo(10);
        Assertions.assertThat((String)this.converter.convert((Object)"1234567890").toString()).isEqualTo((Object)"1234567890");
        Assertions.assertThat((int)this.converter.convert((Object)"1234567890").toString().length()).isEqualTo(10);
        Assertions.assertThat((String)this.converter.convert((Object)"123456789").toString()).isEqualTo((Object)"123456789");
        Assertions.assertThat((int)this.converter.convert((Object)"123456789").toString().length()).isEqualTo(9);
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    @Test
    public void shouldMaskStringsToFixedLength() {
        String maskValue = "**********";
        Configuration config = Configuration.create().with("column.mask.with.10.chars", this.fullyQualifiedNames).build();
        this.mappers = ColumnMappers.create((RelationalDatabaseConnectorConfig)new TestRelationalDatabaseConfig(config, "test", null, null, 0));
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"1234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"123456789")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldMaskStringsToFixedNumberOfSpecifiedCharacters() {
        char maskChar = '=';
        String maskValue = Strings.createString((char)maskChar, (int)10);
        this.mappers = ColumnMappers.build().maskStrings(this.fullyQualifiedNames, maskValue.length(), maskChar).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"1234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"123456789")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldMaskStringsWithSpecificValue() {
        String maskValue = "*-*-*-*-*";
        this.mappers = ColumnMappers.build().maskStrings(this.fullyQualifiedNames, maskValue).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"1234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"123456789")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldMapValuesUsingColumnMapperInstance() {
        RepeatingColumnMapper mapper = new RepeatingColumnMapper();
        this.mappers = ColumnMappers.build().map(this.fullyQualifiedNames, (ColumnMapper)mapper).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"1234")).isEqualTo((Object)"12341234");
        Assertions.assertThat((Object)this.converter.convert((Object)"a")).isEqualTo((Object)"aa");
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    @Test
    public void shouldMapValuesUsingFunctionByClassName() {
        this.mappers = ColumnMappers.build().map(this.fullyQualifiedNames, RepeatingColumnMapper.class.getName()).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"1234")).isEqualTo((Object)"12341234");
        Assertions.assertThat((Object)this.converter.convert((Object)"a")).isEqualTo((Object)"aa");
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-5366"})
    public void shouldMaskStringsToMaskHashV1Column() {
        String maskValue = "5944c66655670e4ce234df8529d452ba1cae10a641b9cd1583abf62585b8515a";
        Configuration config = Configuration.create().with("column.mask.hash.SHA-256.with.salt.salt123", this.fullyQualifiedNames).build();
        this.mappers = ColumnMappers.create((RelationalDatabaseConnectorConfig)new TestRelationalDatabaseConfig(config, "test", null, null, 0));
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    @Test
    @FixFor(value={"DBZ-5366"})
    public void shouldMaskStringsToMaskHashV2Column() {
        String maskValue = "b65875d34a3dedf070f3a012970bf3b5da424560d7be3d2c23b986b525d2d7f3";
        Configuration config = Configuration.create().with("column.mask.hash.v2.SHA-256.with.salt.salt123", this.fullyQualifiedNames).build();
        this.mappers = ColumnMappers.create((RelationalDatabaseConnectorConfig)new TestRelationalDatabaseConfig(config, "test", null, null, 0));
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    public static class RepeatingColumnMapper
    implements ColumnMapper {
        public ValueConverter create(Column column) {
            return value -> value == null ? null : value.toString() + value.toString();
        }
    }
}

