/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.base;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.ConfigurationDefaults;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.time.Temporals;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Metronome;
import io.debezium.util.ObjectSizeCalculator;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ChangeEventQueue<T>
implements ChangeEventQueueMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeEventQueue.class);
    private final Duration pollInterval;
    private final int maxBatchSize;
    private final int maxQueueSize;
    private final long maxQueueSizeInBytes;
    private final BlockingQueue<T> queue;
    private final Metronome metronome;
    private final Supplier<LoggingContext.PreviousContext> loggingContextSupplier;
    private final AtomicLong currentQueueSizeInBytes = new AtomicLong(0L);
    private final Map<T, Long> objectMap = new ConcurrentHashMap<T, Long>();
    private boolean buffering;
    private T bufferedEvent;
    private volatile RuntimeException producerException;

    private ChangeEventQueue(Duration pollInterval, int maxQueueSize, int maxBatchSize, Supplier<LoggingContext.PreviousContext> loggingContextSupplier, long maxQueueSizeInBytes, boolean buffering) {
        this.pollInterval = pollInterval;
        this.maxBatchSize = maxBatchSize;
        this.maxQueueSize = maxQueueSize;
        this.queue = new LinkedBlockingDeque<T>(maxQueueSize);
        this.metronome = Metronome.sleeper(pollInterval, Clock.SYSTEM);
        this.loggingContextSupplier = loggingContextSupplier;
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
        this.buffering = buffering;
    }

    public void enqueue(T record) throws InterruptedException {
        if (record == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.buffering) {
            T newEvent = record;
            record = this.bufferedEvent;
            this.bufferedEvent = newEvent;
            if (record == null) {
                return;
            }
        }
        this.doEnqueue(record);
    }

    public void flushBuffer(Function<T, T> recordModifier) throws InterruptedException {
        assert (this.buffering) : "Unsuported for queues with disabled buffering";
        if (this.bufferedEvent != null) {
            this.doEnqueue(recordModifier.apply(this.bufferedEvent));
            this.bufferedEvent = null;
        }
    }

    public void disableBuffering() {
        assert (this.bufferedEvent == null) : "Buffer must be flushed";
        this.buffering = false;
    }

    protected void doEnqueue(T record) throws InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Enqueuing source record '{}'", record);
        }
        while (this.maxQueueSizeInBytes > 0L && this.currentQueueSizeInBytes.get() > this.maxQueueSizeInBytes) {
            Thread.sleep(this.pollInterval.toMillis());
        }
        if (this.maxQueueSizeInBytes > 0L) {
            long messageSize = ObjectSizeCalculator.getObjectSize(record);
            this.objectMap.put(record, messageSize);
            this.currentQueueSizeInBytes.addAndGet(messageSize);
        }
        this.queue.put(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> poll() throws InterruptedException {
        LoggingContext.PreviousContext previousContext = this.loggingContextSupplier.get();
        try {
            LOGGER.debug("polling records...");
            ArrayList records = new ArrayList();
            Threads.Timer timeout = Threads.timer(Clock.SYSTEM, Temporals.min(this.pollInterval, ConfigurationDefaults.RETURN_CONTROL_INTERVAL));
            while (!timeout.expired() && this.queue.drainTo(records, this.maxBatchSize) == 0) {
                this.throwProducerExceptionIfPresent();
                LOGGER.debug("no records available yet, sleeping a bit...");
                this.metronome.pause();
                LOGGER.debug("checking for more records...");
            }
            if (this.maxQueueSizeInBytes > 0L && records.size() > 0) {
                records.parallelStream().forEach(record -> {
                    if (this.objectMap.containsKey(record)) {
                        this.currentQueueSizeInBytes.addAndGet(-this.objectMap.get(record).longValue());
                        this.objectMap.remove(record);
                    }
                });
            }
            ArrayList arrayList = records;
            return arrayList;
        }
        finally {
            previousContext.restore();
        }
    }

    public void producerException(RuntimeException producerException) {
        this.producerException = producerException;
    }

    private void throwProducerExceptionIfPresent() {
        if (this.producerException != null) {
            throw this.producerException;
        }
    }

    @Override
    public int totalCapacity() {
        return this.maxQueueSize;
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public long maxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    @Override
    public long currentQueueSizeInBytes() {
        return this.currentQueueSizeInBytes.get();
    }

    public static class Builder<T> {
        private Duration pollInterval;
        private int maxQueueSize;
        private int maxBatchSize;
        private Supplier<LoggingContext.PreviousContext> loggingContextSupplier;
        private long maxQueueSizeInBytes;
        private boolean buffering;

        public Builder<T> pollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        public Builder<T> maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder<T> maxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder<T> loggingContextSupplier(Supplier<LoggingContext.PreviousContext> loggingContextSupplier) {
            this.loggingContextSupplier = loggingContextSupplier;
            return this;
        }

        public Builder<T> maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            this.maxQueueSizeInBytes = maxQueueSizeInBytes;
            return this;
        }

        public Builder<T> buffering() {
            this.buffering = true;
            return this;
        }

        public ChangeEventQueue<T> build() {
            return new ChangeEventQueue(this.pollInterval, this.maxQueueSize, this.maxBatchSize, this.loggingContextSupplier, this.maxQueueSizeInBytes, this.buffering);
        }
    }
}

