/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.document.Array;
import io.debezium.function.Predicates;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.JsonTableChangeSerializer;
import io.debezium.relational.history.TableChanges;
import io.debezium.text.ParsingException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseHistory
implements DatabaseHistory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Configuration config;
    private HistoryRecordComparator comparator = HistoryRecordComparator.INSTANCE;
    private boolean skipUnparseableDDL;
    private Function<String, Optional<Pattern>> ddlFilter = x -> Optional.empty();
    private DatabaseHistoryListener listener = DatabaseHistoryListener.NOOP;
    private boolean useCatalogBeforeSchema;
    private TableChanges.TableChangesSerializer<Array> tableChangesSerializer = new JsonTableChangeSerializer();

    protected AbstractDatabaseHistory() {
    }

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, DatabaseHistoryListener listener, boolean useCatalogBeforeSchema) {
        this.config = config;
        this.comparator = comparator != null ? comparator : HistoryRecordComparator.INSTANCE;
        this.skipUnparseableDDL = config.getBoolean(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS);
        String ddlFilter = config.getString(DatabaseHistory.DDL_FILTER);
        this.ddlFilter = ddlFilter != null ? Predicates.matchedBy(ddlFilter) : this.ddlFilter;
        this.listener = listener;
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
    }

    @Override
    public void start() {
        this.listener.started();
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String ddl) throws DatabaseHistoryException {
        this.record(source, position, databaseName, null, ddl, null);
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String schemaName, String ddl, TableChanges changes) throws DatabaseHistoryException {
        HistoryRecord record = new HistoryRecord(source, position, databaseName, schemaName, ddl, changes);
        this.storeRecord(record);
        this.listener.onChangeApplied(record);
    }

    @Override
    public final void recover(Map<String, ?> source, Map<String, ?> position, Tables schema, DdlParser ddlParser) {
        this.logger.debug("Recovering DDL history for source partition {} and offset {}", source, position);
        this.listener.recoveryStarted();
        HistoryRecord stopPoint = new HistoryRecord(source, position, null, null, null, null);
        this.recoverRecords(recovered -> {
            this.listener.onChangeFromHistory((HistoryRecord)recovered);
            if (this.comparator.isAtOrBefore((HistoryRecord)recovered, stopPoint)) {
                Array tableChanges = recovered.tableChanges();
                String ddl = recovered.ddl();
                if (tableChanges != null) {
                    TableChanges changes = this.tableChangesSerializer.deserialize(tableChanges, this.useCatalogBeforeSchema);
                    for (TableChanges.TableChange entry : changes) {
                        if (entry.getType() == TableChanges.TableChangeType.CREATE || entry.getType() == TableChanges.TableChangeType.ALTER) {
                            schema.overwriteTable(entry.getTable());
                            continue;
                        }
                        schema.removeTable(entry.getId());
                    }
                    this.listener.onChangeApplied((HistoryRecord)recovered);
                } else if (ddl != null && ddlParser != null) {
                    Optional<Pattern> filteredBy;
                    if (recovered.databaseName() != null) {
                        ddlParser.setCurrentDatabase(recovered.databaseName());
                    }
                    if (recovered.schemaName() != null) {
                        ddlParser.setCurrentSchema(recovered.schemaName());
                    }
                    if ((filteredBy = this.ddlFilter.apply(ddl)).isPresent()) {
                        this.logger.info("a DDL '{}' was filtered out of processing by regular expression '{}", (Object)ddl, (Object)filteredBy.get());
                        return;
                    }
                    try {
                        this.logger.debug("Applying: {}", (Object)ddl);
                        ddlParser.parse(ddl, schema);
                        this.listener.onChangeApplied((HistoryRecord)recovered);
                    }
                    catch (ParsingException e) {
                        if (this.skipUnparseableDDL) {
                            this.logger.warn("Ignoring unparseable statements '{}' stored in database history: {}", (Object)ddl, (Object)e);
                        }
                        throw e;
                    }
                }
            } else {
                this.logger.debug("Skipping: {}", (Object)recovered.ddl());
            }
        });
        this.listener.recoveryStopped();
    }

    protected abstract void storeRecord(HistoryRecord var1) throws DatabaseHistoryException;

    protected abstract void recoverRecords(Consumer<HistoryRecord> var1);

    @Override
    public void stop() {
        this.listener.stopped();
    }

    @Override
    public void initializeStorage() {
    }
}

