/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.util.Collect;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeRegistry.class);
    public static final String TYPE_NAME_GEOGRAPHY = "geography";
    public static final String TYPE_NAME_GEOMETRY = "geometry";
    public static final String TYPE_NAME_CITEXT = "citext";
    public static final String TYPE_NAME_HSTORE = "hstore";
    public static final String TYPE_NAME_LTREE = "ltree";
    public static final String TYPE_NAME_ISBN = "isbn";
    public static final String TYPE_NAME_HSTORE_ARRAY = "_hstore";
    public static final String TYPE_NAME_GEOGRAPHY_ARRAY = "_geography";
    public static final String TYPE_NAME_GEOMETRY_ARRAY = "_geometry";
    public static final String TYPE_NAME_CITEXT_ARRAY = "_citext";
    public static final String TYPE_NAME_LTREE_ARRAY = "_ltree";
    public static final int NO_TYPE_MODIFIER = -1;
    public static final int UNKNOWN_LENGTH = -1;
    public static final int DOMAIN_TYPE = 2001;
    private static final String CATEGORY_ARRAY = "A";
    private static final String CATEGORY_ENUM = "E";
    private static final String SQL_ENUM_VALUES = "SELECT t.enumtypid as id, array_agg(t.enumlabel) as values FROM pg_catalog.pg_enum t GROUP BY id";
    private static final String SQL_TYPES = "SELECT t.oid AS oid, t.typname AS name, t.typelem AS element, t.typbasetype AS parentoid, t.typtypmod as modifiers, t.typcategory as category, e.values as enum_values FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid) LEFT JOIN (SELECT t.enumtypid as id, array_agg(t.enumlabel) as values FROM pg_catalog.pg_enum t GROUP BY id) e ON (t.oid = e.id) WHERE n.nspname != 'pg_toast'";
    private static final String SQL_NAME_LOOKUP = "SELECT t.oid AS oid, t.typname AS name, t.typelem AS element, t.typbasetype AS parentoid, t.typtypmod as modifiers, t.typcategory as category, e.values as enum_values FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid) LEFT JOIN (SELECT t.enumtypid as id, array_agg(t.enumlabel) as values FROM pg_catalog.pg_enum t GROUP BY id) e ON (t.oid = e.id) WHERE n.nspname != 'pg_toast' AND t.typname = ?";
    private static final String SQL_OID_LOOKUP = "SELECT t.oid AS oid, t.typname AS name, t.typelem AS element, t.typbasetype AS parentoid, t.typtypmod as modifiers, t.typcategory as category, e.values as enum_values FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid) LEFT JOIN (SELECT t.enumtypid as id, array_agg(t.enumlabel) as values FROM pg_catalog.pg_enum t GROUP BY id) e ON (t.oid = e.id) WHERE n.nspname != 'pg_toast' AND t.oid = ?";
    private static final Map<String, String> LONG_TYPE_NAMES = Collections.unmodifiableMap(TypeRegistry.getLongTypeNames());
    private final Map<String, PostgresType> nameToType = new HashMap<String, PostgresType>();
    private final Map<Integer, PostgresType> oidToType = new HashMap<Integer, PostgresType>();
    private final PostgresConnection connection;
    private final SqlTypeMapper sqlTypeMapper;
    private int geometryOid = Integer.MIN_VALUE;
    private int geographyOid = Integer.MIN_VALUE;
    private int citextOid = Integer.MIN_VALUE;
    private int hstoreOid = Integer.MIN_VALUE;
    private int ltreeOid = Integer.MIN_VALUE;
    private int isbnOid = Integer.MIN_VALUE;
    private int hstoreArrayOid = Integer.MIN_VALUE;
    private int geometryArrayOid = Integer.MIN_VALUE;
    private int geographyArrayOid = Integer.MIN_VALUE;
    private int citextArrayOid = Integer.MIN_VALUE;
    private int ltreeArrayOid = Integer.MIN_VALUE;

    private static Map<String, String> getLongTypeNames() {
        HashMap<String, String> longTypeNames = new HashMap<String, String>();
        longTypeNames.put("bigint", "int8");
        longTypeNames.put("bit varying", "varbit");
        longTypeNames.put("boolean", "bool");
        longTypeNames.put("character", "bpchar");
        longTypeNames.put("character varying", "varchar");
        longTypeNames.put("double precision", "float8");
        longTypeNames.put("integer", "int4");
        longTypeNames.put("real", "float4");
        longTypeNames.put("smallint", "int2");
        longTypeNames.put("timestamp without time zone", "timestamp");
        longTypeNames.put("timestamp with time zone", "timestamptz");
        longTypeNames.put("time without time zone", "time");
        longTypeNames.put("time with time zone", "timetz");
        return longTypeNames;
    }

    public TypeRegistry(PostgresConnection connection) {
        try {
            this.connection = connection;
            this.sqlTypeMapper = new SqlTypeMapper(this.connection);
            this.prime();
        }
        catch (SQLException e) {
            throw new DebeziumException("Couldn't initialize type registry", (Throwable)e);
        }
    }

    private void addType(PostgresType type) {
        this.oidToType.put(type.getOid(), type);
        this.nameToType.put(type.getName(), type);
        if (TYPE_NAME_GEOMETRY.equals(type.getName())) {
            this.geometryOid = type.getOid();
        } else if (TYPE_NAME_GEOGRAPHY.equals(type.getName())) {
            this.geographyOid = type.getOid();
        } else if (TYPE_NAME_CITEXT.equals(type.getName())) {
            this.citextOid = type.getOid();
        } else if (TYPE_NAME_HSTORE.equals(type.getName())) {
            this.hstoreOid = type.getOid();
        } else if (TYPE_NAME_LTREE.equals(type.getName())) {
            this.ltreeOid = type.getOid();
        } else if (TYPE_NAME_HSTORE_ARRAY.equals(type.getName())) {
            this.hstoreArrayOid = type.getOid();
        } else if (TYPE_NAME_GEOMETRY_ARRAY.equals(type.getName())) {
            this.geometryArrayOid = type.getOid();
        } else if (TYPE_NAME_GEOGRAPHY_ARRAY.equals(type.getName())) {
            this.geographyArrayOid = type.getOid();
        } else if (TYPE_NAME_CITEXT_ARRAY.equals(type.getName())) {
            this.citextArrayOid = type.getOid();
        } else if (TYPE_NAME_LTREE_ARRAY.equals(type.getName())) {
            this.ltreeArrayOid = type.getOid();
        } else if (TYPE_NAME_ISBN.equals(type.getName())) {
            this.isbnOid = type.getOid();
        }
    }

    public PostgresType get(int oid) {
        PostgresType r = this.oidToType.get(oid);
        if (r == null && (r = this.resolveUnknownType(oid)) == null) {
            LOGGER.warn("Unknown OID {} requested", (Object)oid);
            r = PostgresType.UNKNOWN;
        }
        return r;
    }

    public PostgresType get(String name) {
        PostgresType r;
        switch (name) {
            case "serial": {
                name = "int4";
                break;
            }
            case "smallserial": {
                name = "int2";
                break;
            }
            case "bigserial": {
                name = "int8";
            }
        }
        String[] parts = name.split("\\.");
        if (parts.length > 1) {
            name = parts[1];
        }
        if (name.charAt(0) == '\"') {
            name = name.substring(1, name.length() - 1);
        }
        if ((r = this.nameToType.get(name)) == null && (r = this.resolveUnknownType(name)) == null) {
            LOGGER.warn("Unknown type named {} requested", (Object)name);
            r = PostgresType.UNKNOWN;
        }
        return r;
    }

    public Map<String, PostgresType> getRegisteredTypes() {
        return Collections.unmodifiableMap(this.nameToType);
    }

    public int geometryOid() {
        return this.geometryOid;
    }

    public int geographyOid() {
        return this.geographyOid;
    }

    public int citextOid() {
        return this.citextOid;
    }

    public int hstoreOid() {
        return this.hstoreOid;
    }

    public int ltreeOid() {
        return this.ltreeOid;
    }

    public int isbnOid() {
        return this.isbnOid;
    }

    public int hstoreArrayOid() {
        return this.hstoreArrayOid;
    }

    public int geometryArrayOid() {
        return this.geometryArrayOid;
    }

    public int geographyArrayOid() {
        return this.geographyArrayOid;
    }

    public int citextArrayOid() {
        return this.citextArrayOid;
    }

    public int ltreeArrayOid() {
        return this.ltreeArrayOid;
    }

    public static String normalizeTypeName(String typeName) {
        return LONG_TYPE_NAMES.getOrDefault(typeName, typeName);
    }

    private void prime() throws SQLException {
        try (Statement statement = this.connection.connection().createStatement();
             ResultSet rs = statement.executeQuery(SQL_TYPES);){
            ArrayList<PostgresType.Builder> delayResolvedBuilders = new ArrayList<PostgresType.Builder>();
            while (rs.next()) {
                PostgresType.Builder builder = this.createTypeBuilderFromResultSet(rs);
                if (!builder.hasParentType()) {
                    this.addType(builder.build());
                    continue;
                }
                delayResolvedBuilders.add(builder);
            }
            for (PostgresType.Builder builder : delayResolvedBuilders) {
                this.addType(builder.build());
            }
        }
    }

    private PostgresType.Builder createTypeBuilderFromResultSet(ResultSet rs) throws SQLException {
        int oid = (int)rs.getLong("oid");
        int parentTypeOid = (int)rs.getLong("parentoid");
        int modifiers = (int)rs.getLong("modifiers");
        String typeName = rs.getString("name");
        String category = rs.getString("category");
        PostgresType.Builder builder = new PostgresType.Builder(this, typeName, oid, this.sqlTypeMapper.getSqlType(typeName), modifiers, TypeRegistry.getTypeInfo(this.connection));
        if (CATEGORY_ENUM.equals(category)) {
            String[] enumValues = (String[])rs.getArray("enum_values").getArray();
            builder = builder.enumValues(Arrays.asList(enumValues));
        } else if (CATEGORY_ARRAY.equals(category)) {
            builder = builder.elementType((int)rs.getLong("element"));
        }
        return builder.parentType(parentTypeOid);
    }

    private PostgresType resolveUnknownType(String name) {
        PostgresType postgresType;
        block8: {
            LOGGER.trace("Type '{}' not cached, attempting to lookup from database.", (Object)name);
            PreparedStatement statement = this.connection.connection().prepareStatement(SQL_NAME_LOOKUP);
            try {
                statement.setString(1, name);
                postgresType = this.loadType(statement);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ConnectException("Database connection failed during resolving unknown type", (Throwable)e);
                }
            }
            statement.close();
        }
        return postgresType;
    }

    private PostgresType resolveUnknownType(int lookupOid) {
        PostgresType postgresType;
        block8: {
            LOGGER.trace("Type OID '{}' not cached, attempting to lookup from database.", (Object)lookupOid);
            PreparedStatement statement = this.connection.connection().prepareStatement(SQL_OID_LOOKUP);
            try {
                statement.setInt(1, lookupOid);
                postgresType = this.loadType(statement);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ConnectException("Database connection failed during resolving unknown type", (Throwable)e);
                }
            }
            statement.close();
        }
        return postgresType;
    }

    private PostgresType loadType(PreparedStatement statement) throws SQLException {
        try (ResultSet rs = statement.executeQuery();){
            if (rs.next()) {
                PostgresType result = this.createTypeBuilderFromResultSet(rs).build();
                this.addType(result);
                PostgresType postgresType = result;
                return postgresType;
            }
        }
        return null;
    }

    public int isbn() {
        return this.isbnOid;
    }

    private static TypeInfo getTypeInfo(PostgresConnection connection) throws SQLException {
        return ((BaseConnection)connection.connection()).getTypeInfo();
    }

    private static class SqlTypeMapper {
        private static final String SQL_TYPE_DETAILS = "SELECT DISTINCT ON (typname) typname, typinput='array_in'::regproc, typtype, sp.r, pg_type.oid   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  ORDER BY typname, sp.r, pg_type.oid;";
        private final PostgresConnection connection;
        @Immutable
        private final Set<String> preloadedSqlTypes;
        @Immutable
        private final Map<String, Integer> sqlTypesByPgTypeNames;

        private SqlTypeMapper(PostgresConnection connection) throws SQLException {
            this.connection = connection;
            this.preloadedSqlTypes = Collect.unmodifiableSet((Iterator)TypeRegistry.getTypeInfo(connection).getPGTypeNamesWithSQLTypes());
            this.sqlTypesByPgTypeNames = Collections.unmodifiableMap(SqlTypeMapper.getSqlTypes(connection));
        }

        public int getSqlType(String typeName) throws SQLException {
            boolean isCoreType = this.preloadedSqlTypes.contains(typeName);
            if (isCoreType) {
                return TypeRegistry.getTypeInfo(this.connection).getSQLType(typeName);
            }
            if (typeName.endsWith("[]")) {
                return 2003;
            }
            try {
                Integer pgType = this.sqlTypesByPgTypeNames.get(typeName);
                if (pgType != null) {
                    return pgType;
                }
                LOGGER.info("Failed to obtain SQL type information for type {} via custom statement, falling back to TypeInfo#getSQLType()", (Object)typeName);
                return TypeRegistry.getTypeInfo(this.connection).getSQLType(typeName);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to obtain SQL type information for type {} via custom statement, falling back to TypeInfo#getSQLType()", (Object)typeName, (Object)e);
                return TypeRegistry.getTypeInfo(this.connection).getSQLType(typeName);
            }
        }

        private static Map<String, Integer> getSqlTypes(PostgresConnection connection) throws SQLException {
            HashMap<String, Integer> sqlTypesByPgTypeNames = new HashMap<String, Integer>();
            try (Statement statement = connection.connection().createStatement();
                 ResultSet rs = statement.executeQuery(SQL_TYPE_DETAILS);){
                while (rs.next()) {
                    boolean isArray = rs.getBoolean(2);
                    String typtype = rs.getString(3);
                    int type = isArray ? 2003 : ("c".equals(typtype) ? 2002 : ("d".equals(typtype) ? 2001 : ("e".equals(typtype) ? 12 : 1111)));
                    sqlTypesByPgTypeNames.put(rs.getString(1), type);
                }
            }
            return sqlTypesByPgTypeNames;
        }
    }
}

