/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleDatabaseVersion;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.xstream.LcrEventHandler;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.connector.oracle.xstream.XStreamStreamingChangeEventSourceMetrics;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import oracle.sql.NUMBER;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import oracle.streams.XStreamOut;
import oracle.streams.XStreamUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XstreamStreamingChangeEventSource
implements StreamingChangeEventSource<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XstreamStreamingChangeEventSource.class);
    private static final int DEFAULT_MAX_ATTACH_RETRIES = 10;
    private static final int DEFAULT_MAX_ATTACH_RETRY_DELAY_SECONDS = 10;
    private final OracleConnectorConfig connectorConfig;
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final XStreamStreamingChangeEventSourceMetrics streamingMetrics;
    private final String xStreamServerName;
    private volatile XStreamOut xsOut;
    private final int posVersion;
    private final AtomicReference<PositionAndScn> lcrMessage = new AtomicReference();
    private OracleOffsetContext effectiveOffset;

    public XstreamStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, XStreamStreamingChangeEventSourceMetrics streamingMetrics) {
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.streamingMetrics = streamingMetrics;
        this.xStreamServerName = connectorConfig.getXoutServerName();
        this.posVersion = XstreamStreamingChangeEventSource.resolvePosVersion(jdbcConnection, connectorConfig);
    }

    public void init(OracleOffsetContext offsetContext) throws InterruptedException {
        this.effectiveOffset = offsetContext == null ? this.emptyContext() : offsetContext;
    }

    private OracleOffsetContext emptyContext() {
        return OracleOffsetContext.create().logicalName(this.connectorConfig).snapshotPendingTransactions(Collections.emptyMap()).transactionContext(new TransactionContext()).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, OraclePartition partition, OracleOffsetContext offsetContext) throws InterruptedException {
        this.effectiveOffset = offsetContext;
        LcrEventHandler eventHandler = new LcrEventHandler(this.connectorConfig, this.errorHandler, this.dispatcher, this.clock, this.schema, partition, offsetContext, StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE.equals((Object)this.connectorConfig.getAdapter().getTableNameCaseSensitivity(this.jdbcConnection)), this, this.streamingMetrics);
        try (OracleConnection xsConnection = this.connectAndAttachWithRetries(this.jdbcConnection.config(), this.getStartPosition(offsetContext));){
            try {
                while (context.isRunning()) {
                    LOGGER.trace("Receiving LCR");
                    this.xsOut.receiveLCRCallback((XStreamLCRCallbackHandler)eventHandler, 0);
                    this.dispatcher.dispatchHeartbeatEvent((Partition)partition, (OffsetContext)offsetContext);
                    if (!context.isPaused()) continue;
                    LOGGER.info("Streaming will now pause");
                    context.streamingPaused();
                    context.waitSnapshotCompletion();
                    LOGGER.info("Streaming resumed");
                }
            }
            finally {
                if (this.xsOut != null) {
                    try {
                        XStreamOut xsOut = this.xsOut;
                        this.xsOut = null;
                        xsOut.detach(0);
                    }
                    catch (StreamsException e) {
                        LOGGER.error("Couldn't detach from XStream outbound server " + this.xStreamServerName, (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.errorHandler.setProducerThrowable(e);
        }
    }

    public void commitOffset(Map<String, ?> partition, Map<String, ?> offset) {
        if (this.xsOut != null) {
            LOGGER.debug("Sending message to request recording of offsets to Oracle");
            LcrPosition lcrPosition = LcrPosition.valueOf((String)offset.get("lcr_position"));
            Scn scn = OracleOffsetContext.getScnFromOffsetMapByKey(offset, "scn");
            this.sendPublishedPosition(lcrPosition, scn);
        }
    }

    public OracleOffsetContext getOffsetContext() {
        return this.effectiveOffset;
    }

    private byte[] getStartPosition(OracleOffsetContext offsetContext) {
        String lcrPosition = offsetContext.getLcrPosition();
        if (lcrPosition != null) {
            return LcrPosition.valueOf(lcrPosition).getRawPosition();
        }
        return this.convertScnToPosition(offsetContext.getScn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleConnection connectAndAttachWithRetries(JdbcConfiguration jdbcConfig, byte[] startPosition) throws Exception {
        OracleConnection connection = null;
        for (int attempt = 1; attempt <= 10; ++attempt) {
            XStreamOut out = null;
            try {
                connection = new OracleConnection(this.connectorConfig, jdbcConfig);
                this.xsOut = out = XStreamOut.attach((oracle.jdbc.OracleConnection)((oracle.jdbc.OracleConnection)connection.connection()), (String)this.xStreamServerName, (byte[])startPosition, (int)1, (int)1, (int)0);
                OracleConnection oracleConnection = connection;
                return oracleConnection;
            }
            catch (StreamsException e) {
                if (this.isAttachExceptionRetriable(e) && attempt != 10) continue;
                if (attempt == 10) {
                    LOGGER.warn("Failed to attach to outbound server with max attempts", (Throwable)e);
                }
                throw e;
            }
            finally {
                if (this.xsOut == null && connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        throw new DebeziumException("Failed to attach to the Oracle XStream outbound server");
    }

    private boolean isAttachExceptionRetriable(StreamsException e) {
        return e.getErrorCode() == 26653 || e.getErrorCode() == 23656 || e.getErrorCode() == 26928 || e.getMessage().contains("did not start properly and is currently in state") || e.getMessage().contains("Timeout occurred while starting XStream process") || e.getMessage().contains("Unable to communicate with XStream apply coordinator process");
    }

    private byte[] convertScnToPosition(Scn scn) {
        try {
            return XStreamUtility.convertSCNToPosition((NUMBER)new NUMBER(scn.toString(), 0), (int)this.posVersion);
        }
        catch (SQLException | StreamsException e) {
            throw new RuntimeException(e);
        }
    }

    XStreamOut getXsOut() {
        return this.xsOut;
    }

    private void sendPublishedPosition(LcrPosition lcrPosition, Scn scn) {
        this.lcrMessage.set(new PositionAndScn(lcrPosition, scn != null ? this.convertScnToPosition(scn) : null));
    }

    PositionAndScn receivePublishedPosition() {
        return this.lcrMessage.getAndSet(null);
    }

    private static int resolvePosVersion(OracleConnection connection, OracleConnectorConfig connectorConfig) {
        OracleDatabaseVersion databaseVersion = connection.getOracleVersion();
        if (databaseVersion.getMajor() == 11 || databaseVersion.getMajor() == 12 && databaseVersion.getMaintenance() < 2) {
            return 1;
        }
        return 2;
    }

    public static class PositionAndScn {
        public final LcrPosition position;
        public final byte[] scn;

        public PositionAndScn(LcrPosition position, byte[] scn) {
            this.position = position;
            this.scn = scn;
        }
    }
}

