/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.infinispan;

import io.debezium.DebeziumException;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.buffered.AbstractCacheProvider;
import io.debezium.connector.oracle.logminer.buffered.LogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.infinispan.InfinispanLogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.infinispan.InfinispanLogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.infinispan.InfinispanTransaction;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedInfinispanCacheProvider
extends AbstractCacheProvider<InfinispanTransaction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedInfinispanCacheProvider.class);
    private final boolean dropBufferOnStop;
    private final EmbeddedCacheManager cacheManager;
    private final InfinispanLogMinerTransactionCache transactionCache;
    private final InfinispanLogMinerCache<String, String> processedTransactionsCache;
    private final InfinispanLogMinerCache<String, String> schemaChangesCache;

    public EmbeddedInfinispanCacheProvider(OracleConnectorConfig connectorConfig) {
        LOGGER.info("Using Infinispan in embedded mode to buffer transactions");
        this.dropBufferOnStop = connectorConfig.isLogMiningBufferDropOnStop();
        this.cacheManager = new DefaultCacheManager(EmbeddedInfinispanCacheProvider.createGlobalConfig(connectorConfig));
        this.transactionCache = this.createTransactionCache(connectorConfig);
        this.processedTransactionsCache = this.createProcessedTransactionsCache(connectorConfig);
        this.schemaChangesCache = this.createSchemaChangesCache(connectorConfig);
        this.displayCacheStatistics();
    }

    @Override
    public LogMinerTransactionCache<InfinispanTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public LogMinerCache<String, String> getSchemaChangesCache() {
        return this.schemaChangesCache;
    }

    @Override
    public LogMinerCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    public void close() throws Exception {
        if (this.dropBufferOnStop) {
            LOGGER.info("Clearing infinispan caches");
            this.transactionCache.clear();
            this.schemaChangesCache.clear();
            this.processedTransactionsCache.clear();
            this.cacheManager.administration().removeCache("transactions");
            this.cacheManager.administration().removeCache("processed-transactions");
            this.cacheManager.administration().removeCache("schema-changes");
            this.cacheManager.administration().removeCache("events");
        }
        LOGGER.info("Shutting down infinispan embedded caches");
        this.cacheManager.close();
    }

    private InfinispanLogMinerTransactionCache createTransactionCache(OracleConnectorConfig connectorConfig) {
        return new InfinispanLogMinerTransactionCache(this.createCache("transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_TRANSACTIONS), this.createCache("events", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_EVENTS));
    }

    private InfinispanLogMinerCache<String, String> createProcessedTransactionsCache(OracleConnectorConfig connectorConfig) {
        return new InfinispanLogMinerCache<String, String>(this.createCache("processed-transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_PROCESSED_TRANSACTIONS));
    }

    private InfinispanLogMinerCache<String, String> createSchemaChangesCache(OracleConnectorConfig connectorConfig) {
        return new InfinispanLogMinerCache<String, String>(this.createCache("schema-changes", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_SCHEMA_CHANGES));
    }

    private <K, V> BasicCache<K, V> createCache(String cacheName, OracleConnectorConfig connectorConfig, Field field) {
        Objects.requireNonNull(cacheName);
        String cacheConfiguration = connectorConfig.getConfig().getString(field);
        Objects.requireNonNull(cacheConfiguration);
        this.cacheManager.defineConfiguration(cacheName, EmbeddedInfinispanCacheProvider.createCacheConfig(cacheName, cacheConfiguration));
        return this.cacheManager.getCache(cacheName);
    }

    private static GlobalConfiguration createGlobalConfig(OracleConnectorConfig connectorConfig) {
        String globalCacheConfiguration = connectorConfig.getLogMiningInifispanGlobalConfiguration();
        if (globalCacheConfiguration == null) {
            return new GlobalConfigurationBuilder().build();
        }
        ConfigurationBuilderHolder builderHolder = new ParserRegistry().parse(globalCacheConfiguration);
        return builderHolder.getGlobalConfigurationBuilder().build();
    }

    private static Configuration createCacheConfig(String cacheName, String configuration) {
        ConfigurationBuilderHolder builderHolder = new ParserRegistry().parse(configuration);
        Map builders = builderHolder.getNamedConfigurationBuilders();
        if (builders.size() > 1) {
            throw new DebeziumException("Infinispan cache configuration for '" + cacheName + "' contains multiple cache configurations and should only contain one.");
        }
        if (builders.isEmpty()) {
            throw new DebeziumException("Infinispan cache configuration for '" + cacheName + "' contained no valid cache configuration. Please check your connector configuration");
        }
        return ((ConfigurationBuilder)builders.values().iterator().next()).build();
    }
}

