/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.ehcache.serialization;

import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.AbstractSerializerStream;
import io.debezium.relational.TableId;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;

public class SerializerInputStream
extends AbstractSerializerStream {
    private final DataInputStream delegate;

    public SerializerInputStream(InputStream inputStream) {
        this.delegate = new DataInputStream(inputStream);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    public Scn readScn() throws IOException {
        String value = this.readString();
        return value == null ? Scn.NULL : Scn.valueOf(value);
    }

    public TableId readTableId() throws IOException {
        return TableId.parse((String)this.readString());
    }

    public Instant readInstant() throws IOException {
        return Instant.parse(this.readString());
    }

    public boolean readBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    public String readString() throws IOException {
        boolean isNull = this.delegate.readBoolean();
        if (isNull) {
            return null;
        }
        return this.delegate.readUTF();
    }

    public Object[] readObjectArray() throws IOException {
        return this.stringArrayToObjectArray(this.readStringArray());
    }

    protected String[] readStringArray() throws IOException {
        int size = this.readInt();
        String[] data = new String[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readString();
        }
        return data;
    }

    protected Object[] stringArrayToObjectArray(String[] values) {
        Objects.requireNonNull(values);
        Object[] results = Arrays.copyOf(values, values.length, Object[].class);
        for (int i = 0; i < results.length; ++i) {
            if (results[i].equals("$$DBZ-NULL$$")) {
                results[i] = null;
                continue;
            }
            if (!results[i].equals("$$DBZ-UNAVAILABLE-VALUE$$")) continue;
            results[i] = OracleValueConverters.UNAVAILABLE_VALUE;
        }
        return results;
    }
}

