/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.Immutable;
import io.debezium.connector.oracle.Scn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Immutable
public class RedoThreadState {
    private final List<RedoThread> threads;

    private RedoThreadState(List<RedoThread> threads) {
        this.threads = Collections.unmodifiableList(threads);
    }

    public List<RedoThread> getThreads() {
        return this.threads;
    }

    public RedoThread getRedoThread(Integer threadId) {
        return this.getThreads().stream().filter(t -> t.getThreadId().equals(threadId)).findFirst().orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Immutable
    public static class RedoThread {
        private static final String OPEN = "OPEN";
        private static final String DISABLED = "DISABLED";
        private final Integer threadId;
        private final String status;
        private final String enabled;
        private final Long logGroups;
        private final String instanceName;
        private final Instant openTime;
        private final Long currentGroupNumber;
        private final Long currentSequenceNumber;
        private final Scn checkpointScn;
        private final Instant checkpointTime;
        private final Scn enabledScn;
        private final Instant enabledTime;
        private final Scn disabledScn;
        private final Instant disabledTime;
        private final Long lastRedoSequenceNumber;
        private final Long lastRedoBlock;
        private final Scn lastRedoScn;
        private final Instant lastRedoTime;
        private final Long conId;

        public RedoThread(Integer threadId, String status, String enabled, Long logGroups, String instanceName, Instant openTime, Long currentGroupNumber, Long currentSequenceNumber, Scn checkpointScn, Instant checkpointTime, Scn enabledScn, Instant enabledTime, Scn disabledScn, Instant disabledTime, Long lastRedoSequenceNumber, Long lastRedoBlock, Scn lastRedoScn, Instant lastRedoTime, Long conId) {
            this.threadId = threadId;
            this.status = status;
            this.enabled = enabled;
            this.logGroups = logGroups;
            this.instanceName = instanceName;
            this.openTime = openTime;
            this.currentGroupNumber = currentGroupNumber;
            this.currentSequenceNumber = currentSequenceNumber;
            this.checkpointScn = checkpointScn;
            this.checkpointTime = checkpointTime;
            this.enabledScn = enabledScn;
            this.enabledTime = enabledTime;
            this.disabledScn = disabledScn;
            this.disabledTime = disabledTime;
            this.lastRedoSequenceNumber = lastRedoSequenceNumber;
            this.lastRedoBlock = lastRedoBlock;
            this.lastRedoScn = lastRedoScn;
            this.lastRedoTime = lastRedoTime;
            this.conId = conId;
        }

        public Integer getThreadId() {
            return this.threadId;
        }

        public String getStatus() {
            return this.status;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public Long getLogGroups() {
            return this.logGroups;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public Instant getOpenTime() {
            return this.openTime;
        }

        public Long getCurrentGroupNumber() {
            return this.currentGroupNumber;
        }

        public Long getCurrentSequenceNumber() {
            return this.currentSequenceNumber;
        }

        public Scn getCheckpointScn() {
            return this.checkpointScn;
        }

        public Instant getCheckpointTime() {
            return this.checkpointTime;
        }

        public Scn getEnabledScn() {
            return this.enabledScn;
        }

        public Instant getEnabledTime() {
            return this.enabledTime;
        }

        public Scn getDisabledScn() {
            return this.disabledScn;
        }

        public Instant getDisabledTime() {
            return this.disabledTime;
        }

        public Long getLastRedoSequenceNumber() {
            return this.lastRedoSequenceNumber;
        }

        public Long getLastRedoBlock() {
            return this.lastRedoBlock;
        }

        public Scn getLastRedoScn() {
            return this.lastRedoScn;
        }

        public Instant getLastRedoTime() {
            return this.lastRedoTime;
        }

        public Long getConId() {
            return this.conId;
        }

        public boolean isOpen() {
            return OPEN.equals(this.status);
        }

        public boolean isDisabled() {
            return DISABLED.equals(this.enabled);
        }

        public String toString() {
            return "RedoThread{threadId=" + this.threadId + ", status='" + this.status + "', enabled='" + this.enabled + "', logGroups=" + this.logGroups + ", instanceName='" + this.instanceName + "', openTime=" + String.valueOf(this.openTime) + ", currentGroupNumber=" + this.currentGroupNumber + ", currentSequenceNumber=" + this.currentSequenceNumber + ", checkpointScn=" + String.valueOf(this.checkpointScn) + ", checkpointTime=" + String.valueOf(this.checkpointTime) + ", enabledScn=" + String.valueOf(this.enabledScn) + ", enabledTime=" + String.valueOf(this.enabledTime) + ", disabledScn=" + String.valueOf(this.disabledScn) + ", disabledTime=" + String.valueOf(this.disabledTime) + ", lastRedoSequenceNumber=" + this.lastRedoSequenceNumber + ", lastRedoBlock=" + this.lastRedoBlock + ", lastRedoScn=" + String.valueOf(this.lastRedoScn) + ", lastRedoTime=" + String.valueOf(this.lastRedoTime) + ", conId=" + this.conId + "}";
        }

        public static class Builder {
            private final io.debezium.connector.oracle.RedoThreadState$Builder builder;
            private Integer threadId;
            private String status;
            private String enabled;
            private Long logGroups;
            private String instanceName;
            private Instant openTime;
            private Long currentGroupNumber;
            private Long currentSequenceNumber;
            private Scn checkpointScn;
            private Instant checkpointTime;
            private Scn enabledScn;
            private Instant enabledTime;
            private Scn disabledScn;
            private Instant disabledTime;
            private Long lastRedoSequenceNumber;
            private Long lastRedoBlock;
            private Scn lastRedoScn;
            private Instant lastRedoTime;
            private Long conId;

            public Builder(io.debezium.connector.oracle.RedoThreadState$Builder builder) {
                this.builder = builder;
            }

            public Builder threadId(Integer threadId) {
                this.threadId = threadId;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder enabled(String enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder logGroups(Long logGroups) {
                this.logGroups = logGroups;
                return this;
            }

            public Builder instanceName(String instanceName) {
                this.instanceName = instanceName;
                return this;
            }

            public Builder openTime(Instant openTime) {
                this.openTime = openTime;
                return this;
            }

            public Builder currentGroupNumber(Long currentGroupNumber) {
                this.currentGroupNumber = currentGroupNumber;
                return this;
            }

            public Builder currentSequenceNumber(Long currentSequenceNumber) {
                this.currentSequenceNumber = currentSequenceNumber;
                return this;
            }

            public Builder checkpointScn(Scn checkpointScn) {
                this.checkpointScn = checkpointScn;
                return this;
            }

            public Builder checkpointTime(Instant checkpointTime) {
                this.checkpointTime = checkpointTime;
                return this;
            }

            public Builder enabledScn(Scn enabledScn) {
                this.enabledScn = enabledScn;
                return this;
            }

            public Builder enabledTime(Instant enabledTime) {
                this.enabledTime = enabledTime;
                return this;
            }

            public Builder disabledScn(Scn disabledScn) {
                this.disabledScn = disabledScn;
                return this;
            }

            public Builder disabledTime(Instant disabledTime) {
                this.disabledTime = disabledTime;
                return this;
            }

            public Builder lastRedoSequenceNumber(Long lastRedoSequenceNumber) {
                this.lastRedoSequenceNumber = lastRedoSequenceNumber;
                return this;
            }

            public Builder lastRedoBlock(Long lastRedoBlock) {
                this.lastRedoBlock = lastRedoBlock;
                return this;
            }

            public Builder lastRedoScn(Scn lastRedoScn) {
                this.lastRedoScn = lastRedoScn;
                return this;
            }

            public Builder lastRedoTime(Instant lastRedoTime) {
                this.lastRedoTime = lastRedoTime;
                return this;
            }

            public Builder conId(Long conId) {
                this.conId = conId;
                return this;
            }

            public io.debezium.connector.oracle.RedoThreadState$Builder build() {
                RedoThread thread = new RedoThread(this.threadId, this.status, this.enabled, this.logGroups, this.instanceName, this.openTime, this.currentGroupNumber, this.currentSequenceNumber, this.checkpointScn, this.checkpointTime, this.enabledScn, this.enabledTime, this.disabledScn, this.disabledTime, this.lastRedoSequenceNumber, this.lastRedoBlock, this.lastRedoScn, this.lastRedoTime, this.conId);
                this.builder.threads.add(thread);
                return this.builder;
            }
        }
    }

    public static class Builder {
        private final List<RedoThread> threads = new ArrayList<RedoThread>();

        public RedoThread.Builder thread() {
            return new RedoThread.Builder(this);
        }

        public RedoThreadState build() {
            return new RedoThreadState(this.threads);
        }
    }
}

