/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.unbuffered;

import io.debezium.common.annotation.Incubating;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.AbstractLogMinerQueryBuilder;
import io.debezium.util.Strings;

@Incubating
public class UnbufferedLogMinerQueryBuilder
extends AbstractLogMinerQueryBuilder {
    public UnbufferedLogMinerQueryBuilder(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    protected String getPredicates(boolean isCteQuery) {
        String schemaNamePredicate;
        String tableNamePredicate;
        String clientIdPredicate;
        StringBuilder predicates = new StringBuilder(1024);
        predicates.append("(COMMIT_SCN >= ? OR (COMMIT_SCN IS NULL AND INFO IN (' DDL', 'USER DDL (PlSql=0 RecDep=0)')))");
        String multiTenantPredicate = this.getMultiTenantPredicate();
        if (!Strings.isNullOrEmpty((String)multiTenantPredicate)) {
            predicates.append(" AND ").append(multiTenantPredicate);
        }
        predicates.append(" AND OPERATION_CODE IN (").append(this.getOperationCodes(isCteQuery)).append(")");
        String userNamePredicate = this.getUserNamePredicate();
        if (!Strings.isNullOrEmpty((String)userNamePredicate)) {
            predicates.append(" AND ").append(userNamePredicate);
        }
        if (!Strings.isNullOrEmpty((String)(clientIdPredicate = this.getClientIdPredicate()))) {
            predicates.append(" AND ").append(clientIdPredicate);
        }
        if (!Strings.isNullOrEmpty((String)(tableNamePredicate = this.getTableNamePredicate()))) {
            predicates.append(" AND ").append(tableNamePredicate);
        }
        if (!Strings.isNullOrEmpty((String)(schemaNamePredicate = this.getSchemaNamePredicate()))) {
            predicates.append(" AND ").append(schemaNamePredicate);
        }
        return predicates.toString();
    }

    private String getOperationCodes(boolean isCteQuery) {
        if (this.connectorConfig.isLobEnabled()) {
            if (isCteQuery) {
                return "1,2,3,5,9,10,11,27,29,34,68,70,71,91,92,93,255";
            }
            return "1,2,3,5,6,7,9,10,11,27,29,34,36,68,70,71,91,92,93,255";
        }
        if (isCteQuery) {
            return "1,2,3,5,27,34,255";
        }
        return "1,2,3,5,6,7,27,34,36,255";
    }
}

