/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.annotation.ThreadSafe;
import io.debezium.text.ParsingException;
import io.debezium.util.Strings;
import java.nio.charset.StandardCharsets;
import oracle.sql.RAW;

@ThreadSafe
public class XmlWriteParser {
    private static final String XML_WRITE_PREAMBLE = "XML_REDO := ";
    private static final String XML_WRITE_PREAMBLE_NULL = "XML_REDO := NULL";

    public static XmlWrite parse(String redoSql) {
        if (Strings.isNullOrEmpty((String)redoSql) || !redoSql.startsWith(XML_WRITE_PREAMBLE)) {
            throw new ParsingException(null, "XML write operation does not start with XML_REDO preamble");
        }
        try {
            String xml;
            if (XML_WRITE_PREAMBLE_NULL.equals(redoSql)) {
                return new XmlWrite(0, null);
            }
            if (redoSql.charAt(XML_WRITE_PREAMBLE.length()) == '\'') {
                int lastQuoteIndex = redoSql.lastIndexOf(39);
                if (lastQuoteIndex == -1) {
                    throw new IllegalStateException("Failed to find end of XML document");
                }
                xml = redoSql.substring(XML_WRITE_PREAMBLE.length() + 1, lastQuoteIndex);
            } else {
                int lastParenIndex = redoSql.lastIndexOf(41);
                if (lastParenIndex == -1) {
                    throw new IllegalStateException("Failed to find end of XML document");
                }
                String xmlHex = redoSql.substring(XML_WRITE_PREAMBLE.length(), lastParenIndex + 1);
                if (!xmlHex.startsWith("HEXTORAW('") || !xmlHex.endsWith(")")) {
                    throw new IllegalStateException("Invalid HEXTORAW XML decoded data");
                }
                xmlHex = xmlHex.endsWith("')") ? xmlHex.substring(10, xmlHex.length() - 2) : xmlHex.substring(10, xmlHex.length() - 1);
                xml = new String(RAW.hexString2Bytes((String)xmlHex), StandardCharsets.UTF_8);
            }
            int lastColonIndex = redoSql.lastIndexOf(58);
            if (lastColonIndex == -1) {
                throw new IllegalStateException("Failed to find XML document length");
            }
            return new XmlWrite(Integer.parseInt(redoSql.substring(lastColonIndex + 1).trim()), xml);
        }
        catch (Exception e) {
            throw new ParsingException(null, "Failed to parse XML write data", (Throwable)e);
        }
    }

    public record XmlWrite(int length, String data) {
    }
}

