/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.ehcache;

import io.debezium.connector.oracle.logminer.buffered.AbstractLogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.ehcache.CacheCapacityExceededException;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheEvictionListener;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheTransaction;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ehcache.Cache;

public class EhcacheLogMinerTransactionCache
extends AbstractLogMinerTransactionCache<EhcacheTransaction> {
    private final Cache<String, EhcacheTransaction> transactionCache;
    private final Cache<String, LogMinerEvent> eventCache;
    private final EhcacheEvictionListener evictionListener;
    private final Map<String, TreeSet<Integer>> eventIdsByTransactionId = new HashMap<String, TreeSet<Integer>>();

    public EhcacheLogMinerTransactionCache(Cache<String, EhcacheTransaction> transactionCache, Cache<String, LogMinerEvent> eventCache, EhcacheEvictionListener evictionListener) {
        this.transactionCache = transactionCache;
        this.eventCache = eventCache;
        this.evictionListener = evictionListener;
        this.primeHeapCacheFromOffHeapCaches();
    }

    @Override
    public EhcacheTransaction getTransaction(String transactionId) {
        return (EhcacheTransaction)this.transactionCache.get((Object)transactionId);
    }

    @Override
    public void addTransaction(EhcacheTransaction transaction) {
        this.transactionCache.put((Object)transaction.getTransactionId(), (Object)transaction);
        this.checkAndThrowIfEviction("transactions");
        this.eventIdsByTransactionId.put(transaction.getTransactionId(), new TreeSet());
    }

    @Override
    public void removeTransaction(EhcacheTransaction transaction) {
        this.transactionCache.remove((Object)transaction.getTransactionId());
    }

    @Override
    public boolean containsTransaction(String transactionId) {
        return this.eventIdsByTransactionId.containsKey(transactionId);
    }

    @Override
    public boolean isEmpty() {
        return this.eventIdsByTransactionId.isEmpty();
    }

    @Override
    public int getTransactionCount() {
        return this.eventIdsByTransactionId.size();
    }

    @Override
    public <R> R streamTransactionsAndReturn(Function<Stream<EhcacheTransaction>, R> consumer) {
        try (Stream<Cache.Entry> stream = StreamSupport.stream(this.transactionCache.spliterator(), false);){
            R r = consumer.apply(stream.map(Cache.Entry::getValue));
            return r;
        }
    }

    @Override
    public void transactions(Consumer<Stream<EhcacheTransaction>> consumer) {
        try (Stream<Cache.Entry> stream = StreamSupport.stream(this.transactionCache.spliterator(), false);){
            consumer.accept(stream.map(Cache.Entry::getValue));
        }
    }

    @Override
    public void eventKeys(Consumer<Stream<String>> consumer) {
        try (Stream<Cache.Entry> stream = StreamSupport.stream(this.eventCache.spliterator(), false);){
            consumer.accept(stream.map(Cache.Entry::getKey));
        }
    }

    @Override
    public void forEachEvent(EhcacheTransaction transaction, LogMinerTransactionCache.InterruptiblePredicate<LogMinerEvent> predicate) throws InterruptedException {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            try (Stream stream = events.stream();){
                Iterator iterator = stream.iterator();
                while (iterator.hasNext()) {
                    LogMinerEvent event = this.getTransactionEvent(transaction, (int)((Integer)iterator.next()));
                    if (event == null || predicate.test(event)) continue;
                    break;
                }
            }
        }
    }

    @Override
    public LogMinerEvent getTransactionEvent(EhcacheTransaction transaction, int eventKey) {
        return (LogMinerEvent)this.eventCache.get((Object)transaction.getEventId(eventKey));
    }

    @Override
    public EhcacheTransaction getAndRemoveTransaction(String transactionId) {
        EhcacheTransaction transaction = this.getTransaction(transactionId);
        if (transaction != null) {
            this.transactionCache.remove((Object)transactionId);
        }
        return transaction;
    }

    @Override
    public void addTransactionEvent(EhcacheTransaction transaction, int eventKey, LogMinerEvent event) {
        this.eventCache.put((Object)transaction.getEventId(eventKey), (Object)event);
        this.checkAndThrowIfEviction("events");
        this.eventIdsByTransactionId.get(transaction.getTransactionId()).add(eventKey);
    }

    @Override
    public void removeTransactionEvents(EhcacheTransaction transaction) {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            this.eventCache.removeAll(events.stream().map(transaction::getEventId).collect(Collectors.toSet()));
        }
        this.eventIdsByTransactionId.remove(transaction.getTransactionId());
    }

    @Override
    public boolean removeTransactionEventWithRowId(EhcacheTransaction transaction, String rowId) {
        TreeSet<Integer> eventIds = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        for (Integer eventId : eventIds.descendingSet()) {
            String eventKey = transaction.getEventId(eventId);
            LogMinerEvent event = (LogMinerEvent)this.eventCache.get((Object)eventKey);
            if (event == null || !event.getRowId().equals(rowId)) continue;
            this.eventCache.remove((Object)eventKey);
            eventIds.remove(eventId);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTransactionEvent(EhcacheTransaction transaction, int eventKey) {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            return events.contains(eventKey);
        }
        return false;
    }

    @Override
    public int getTransactionEventCount(EhcacheTransaction transaction) {
        TreeSet<Integer> events = this.eventIdsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            return events.size();
        }
        return 0;
    }

    @Override
    public int getTransactionEvents() {
        return this.eventIdsByTransactionId.values().stream().mapToInt(Set::size).sum();
    }

    @Override
    public void clear() {
        this.transactionCache.clear();
        this.eventCache.clear();
        this.eventIdsByTransactionId.clear();
    }

    @Override
    public void resetTransactionToStart(EhcacheTransaction transaction) {
        super.resetTransactionToStart(transaction);
        this.syncTransaction(transaction);
    }

    @Override
    public void syncTransaction(EhcacheTransaction transaction) {
        this.transactionCache.put((Object)transaction.getTransactionId(), (Object)transaction);
        this.checkAndThrowIfEviction("transactions");
    }

    private void primeHeapCacheFromOffHeapCaches() {
        this.eventKeys(keyStream -> keyStream.map(k -> k.split("-", 2)).filter(parts -> ((String[])parts).length == 2).forEach(parts -> {
            String transactionId = parts[0];
            int eventId = Integer.parseInt(parts[1]);
            if (this.transactionCache.containsKey((Object)transactionId)) {
                this.eventIdsByTransactionId.computeIfAbsent(transactionId, k -> new TreeSet()).add(eventId);
            }
        }));
    }

    private void checkAndThrowIfEviction(String cacheName) {
        if (this.evictionListener.hasEvictionBeenSeen()) {
            throw new CacheCapacityExceededException(cacheName);
        }
    }
}

