/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.antlr.listener.BaseParserListener;
import io.debezium.connector.oracle.antlr.listener.ColumnDefinitionParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.text.ParsingException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableParserListener
extends BaseParserListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlterTableParserListener.class);
    private static final int STARTING_INDEX = 1;
    private TableEditor tableEditor;
    private String catalogName;
    private String schemaName;
    private TableId previousTableId;
    private OracleDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private ColumnDefinitionParserListener columnDefinitionParserListener;
    private List<ColumnEditor> columnEditors;
    private int parsingColumnIndex = 1;

    AlterTableParserListener(String catalogName, String schemaName, OracleDdlParser parser, List<ParseTreeListener> listeners) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.parser = parser;
        this.listeners = listeners;
    }

    public void enterAlter_table(PlSqlParser.Alter_tableContext ctx) {
        this.previousTableId = null;
        TableId tableId = new TableId(this.catalogName, this.schemaName, this.getTableName(ctx.tableview_name()));
        if (this.parser.databaseTables().forTable(tableId) == null) {
            LOGGER.debug("Ignoring ALTER TABLE statement for non-captured table {}", (Object)tableId);
            return;
        }
        this.tableEditor = this.parser.databaseTables().editTable(tableId);
        if (this.tableEditor == null) {
            throw new ParsingException(null, "Trying to alter table " + tableId.toString() + ", which does not exist. Query: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
        }
        super.enterAlter_table(ctx);
    }

    public void exitAlter_table(PlSqlParser.Alter_tableContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.listeners.remove((Object)this.columnDefinitionParserListener);
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.parser.signalAlterTable(this.tableEditor.tableId(), this.previousTableId, ctx.getParent());
        }, this.tableEditor);
        super.exitAlter_table(ctx);
    }

    public void enterAlter_table_properties(PlSqlParser.Alter_table_propertiesContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (ctx.RENAME() != null && ctx.TO() != null) {
                this.previousTableId = this.tableEditor.tableId();
                String tableName = this.getTableName(ctx.tableview_name());
                TableId newTableId = new TableId(this.tableEditor.tableId().catalog(), this.tableEditor.tableId().schema(), tableName);
                if (this.parser.getTableFilter().isIncluded(this.previousTableId) && !this.parser.getTableFilter().isIncluded(newTableId)) {
                    LOGGER.warn("Renaming included table {} to non-included table {}, this can lead to schema inconsistency", (Object)this.previousTableId, (Object)newTableId);
                } else if (!this.parser.getTableFilter().isIncluded(this.previousTableId) && this.parser.getTableFilter().isIncluded(newTableId)) {
                    LOGGER.warn("Renaming non-included table {} to included table {}, this can lead to schema inconsistency", (Object)this.previousTableId, (Object)newTableId);
                }
                this.parser.databaseTables().overwriteTable(this.tableEditor.create());
                this.parser.databaseTables().renameTable(this.tableEditor.tableId(), newTableId);
                this.tableEditor = this.parser.databaseTables().editTable(newTableId);
            }
        }, this.tableEditor);
        super.exitAlter_table_properties(ctx);
    }

    public void enterAdd_column_clause(PlSqlParser.Add_column_clauseContext ctx) {
        this.parser.runIfNotNull(() -> {
            List columns = ctx.column_definition();
            this.columnEditors = new ArrayList<ColumnEditor>(columns.size());
            for (PlSqlParser.Column_definitionContext column : columns) {
                String columnName = this.getColumnName(column.column_name());
                ColumnEditor editor = Column.editor().name(columnName);
                this.columnEditors.add(editor);
            }
            this.columnDefinitionParserListener = new ColumnDefinitionParserListener(this.tableEditor, this.columnEditors.get(0), this.parser, this.listeners);
            this.listeners.add((ParseTreeListener)this.columnDefinitionParserListener);
        }, this.tableEditor);
        super.enterAdd_column_clause(ctx);
    }

    public void enterModify_column_clauses(PlSqlParser.Modify_column_clausesContext ctx) {
        this.parser.runIfNotNull(() -> {
            List columns = ctx.modify_col_properties();
            if (!columns.isEmpty()) {
                this.columnEditors = new ArrayList<ColumnEditor>(columns.size());
                for (PlSqlParser.Modify_col_propertiesContext column : columns) {
                    String columnName = this.getColumnName(column.column_name());
                    Column existingColumn = this.tableEditor.columnWithName(columnName);
                    if (existingColumn != null) {
                        ColumnEditor columnEditor = existingColumn.edit();
                        this.columnEditors.add(columnEditor);
                        continue;
                    }
                    throw new ParsingException(null, "trying to change column " + columnName + " in " + this.tableEditor.tableId().toString() + " table, which does not exist.  Query: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
                }
                this.columnDefinitionParserListener = new ColumnDefinitionParserListener(this.tableEditor, this.columnEditors.get(0), this.parser, this.listeners);
                this.listeners.add((ParseTreeListener)this.columnDefinitionParserListener);
            }
        }, this.tableEditor);
        super.enterModify_column_clauses(ctx);
    }

    public void exitAdd_column_clause(PlSqlParser.Add_column_clauseContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
            this.listeners.remove((Object)this.columnDefinitionParserListener);
            this.columnDefinitionParserListener = null;
        }, this.tableEditor, this.columnEditors);
        super.exitAdd_column_clause(ctx);
    }

    public void exitModify_column_clauses(PlSqlParser.Modify_column_clausesContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
            this.listeners.remove((Object)this.columnDefinitionParserListener);
            this.columnDefinitionParserListener = null;
        }, this.tableEditor, this.columnEditors);
        super.exitModify_column_clauses(ctx);
    }

    public void exitColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (this.columnEditors != null) {
                if (this.columnEditors.size() > this.parsingColumnIndex) {
                    this.columnDefinitionParserListener.setColumnEditor(this.columnEditors.get(this.parsingColumnIndex++));
                } else {
                    this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
                    this.columnEditors = null;
                    this.parsingColumnIndex = 1;
                }
            }
        }, this.tableEditor, this.columnEditors);
        super.exitColumn_definition(ctx);
    }

    public void exitModify_col_properties(PlSqlParser.Modify_col_propertiesContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (this.columnEditors != null) {
                if (this.columnEditors.size() > this.parsingColumnIndex) {
                    this.columnDefinitionParserListener.setColumnEditor(this.columnEditors.get(this.parsingColumnIndex++));
                } else {
                    this.columnEditors.forEach(columnEditor -> this.tableEditor.addColumn(columnEditor.create()));
                    this.columnEditors = null;
                    this.parsingColumnIndex = 1;
                }
            }
        }, this.tableEditor, this.columnEditors);
        super.exitModify_col_properties(ctx);
    }

    public void enterDrop_column_clause(PlSqlParser.Drop_column_clauseContext ctx) {
        this.parser.runIfNotNull(() -> {
            List columnNameContexts = ctx.column_name();
            this.columnEditors = new ArrayList<ColumnEditor>(columnNameContexts.size());
            for (PlSqlParser.Column_nameContext columnNameContext : columnNameContexts) {
                String columnName = this.getColumnName(columnNameContext);
                this.tableEditor.removeColumn(columnName);
            }
        }, this.tableEditor);
        super.enterDrop_column_clause(ctx);
    }

    public void exitRename_column_clause(PlSqlParser.Rename_column_clauseContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.renameColumn(this.getColumnName(ctx.old_column_name()), this.getColumnName(ctx.new_column_name())), this.tableEditor);
        super.exitRename_column_clause(ctx);
    }

    public void enterConstraint_clauses(PlSqlParser.Constraint_clausesContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (ctx.ADD() != null) {
                ArrayList<String> primaryKeyColumns = new ArrayList<String>();
                for (PlSqlParser.Out_of_line_constraintContext constraint : ctx.out_of_line_constraint()) {
                    if (constraint.PRIMARY() == null || constraint.KEY() == null) continue;
                    for (PlSqlParser.Column_nameContext columnNameContext : constraint.column_name()) {
                        primaryKeyColumns.add(this.getColumnName(columnNameContext));
                    }
                }
                if (!primaryKeyColumns.isEmpty()) {
                    this.tableEditor.setPrimaryKeyNames(primaryKeyColumns);
                }
            } else if (ctx.MODIFY() != null && ctx.PRIMARY() != null && ctx.KEY() != null) {
                ArrayList<String> primaryKeyColumns = new ArrayList<String>();
                for (PlSqlParser.Column_nameContext columnNameContext : ctx.column_name()) {
                    primaryKeyColumns.add(this.getColumnName(columnNameContext));
                }
                if (!primaryKeyColumns.isEmpty()) {
                    this.tableEditor.setPrimaryKeyNames(primaryKeyColumns);
                }
            }
        }, this.tableEditor);
        super.enterConstraint_clauses(ctx);
    }

    public void enterDrop_constraint_clause(PlSqlParser.Drop_constraint_clauseContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (ctx.PRIMARY() != null) {
                this.tableEditor.setPrimaryKeyNames(new String[0]);
            }
        }, this.tableEditor);
        super.enterDrop_constraint_clause(ctx);
    }
}

