/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimestampUtils {
    private static final ZoneId GMT_ZONE_ID = ZoneId.of("GMT");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().toFormatter();
    private static final DateTimeFormatter TIMESTAMP_AM_PM_SHORT_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("dd-MMM-yy hh.mm.ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().appendPattern(" a").toFormatter(Locale.ENGLISH);
    private static final Pattern TO_TIMESTAMP = Pattern.compile("TO_TIMESTAMP\\('(.*)'\\)", 2);
    private static final Pattern TO_DATE = Pattern.compile("TO_DATE\\('(.*)',[ ]*'(.*)'\\)", 2);

    public static Instant convertTimestampNoZoneToInstant(String value) {
        Matcher toTimestampMatcher = TO_TIMESTAMP.matcher(value);
        if (toTimestampMatcher.matches()) {
            String text = toTimestampMatcher.group(1);
            LocalDateTime dateTime = text.indexOf(" AM") > 0 || text.indexOf(" PM") > 0 ? LocalDateTime.from(TIMESTAMP_AM_PM_SHORT_FORMATTER.parse(text.trim())) : LocalDateTime.from(TIMESTAMP_FORMATTER.parse(text.trim()));
            return dateTime.atZone(GMT_ZONE_ID).toInstant();
        }
        Matcher toDateMatcher = TO_DATE.matcher(value);
        if (toDateMatcher.matches()) {
            return LocalDateTime.from(TIMESTAMP_FORMATTER.parse(toDateMatcher.group(1))).atZone(GMT_ZONE_ID).toInstant();
        }
        return null;
    }

    public static String toSqlCompliantFunctionCall(String value) {
        Matcher timestampMatcher = TO_TIMESTAMP.matcher(value);
        if (timestampMatcher.matches()) {
            String text = timestampMatcher.group(1);
            if (text.indexOf(" AM") > 0 || text.indexOf(" PM") > 0) {
                return "TO_TIMESTAMP('" + text + "', 'YYYY-MM-DD HH24:MI:SS.FF A')";
            }
            return "TO_TIMESTAMP('" + text + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
        }
        Matcher dateMatcher = TO_DATE.matcher(value);
        if (dateMatcher.matches()) {
            return value;
        }
        return null;
    }

    private TimestampUtils() {
    }
}

