/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.ehcache.serialization;

import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.AbstractSerializerStream;
import io.debezium.relational.TableId;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Objects;

public class SerializerOutputStream
extends AbstractSerializerStream {
    private final DataOutputStream delegate;

    public SerializerOutputStream(OutputStream outputStream) {
        this.delegate = new DataOutputStream(outputStream);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    public void writeScn(Scn scn) throws IOException {
        this.writeString(scn == null || scn.isNull() ? null : scn.toString());
    }

    public void writeTableId(TableId tableId) throws IOException {
        Objects.requireNonNull(tableId);
        this.writeString(tableId.toDoubleQuotedString());
    }

    public void writeInstant(Instant instant) throws IOException {
        Objects.requireNonNull(instant);
        this.writeString(instant.toString());
    }

    public void writeBoolean(boolean value) throws IOException {
        this.delegate.writeBoolean(value);
    }

    public void writeInt(int value) throws IOException {
        this.delegate.writeInt(value);
    }

    public void writeString(String value) throws IOException {
        if (value == null) {
            this.delegate.writeBoolean(true);
        } else {
            this.delegate.writeBoolean(false);
            this.delegate.writeUTF(value);
        }
    }

    public void writeObjectArray(Object[] values) throws IOException {
        Objects.requireNonNull(values);
        this.writeStringArray(this.objectArrayToStringArray(values));
    }

    protected void writeStringArray(String[] values) throws IOException {
        Objects.requireNonNull(values);
        this.writeInt(values.length);
        for (String value : values) {
            this.writeString(value);
        }
    }

    protected String[] objectArrayToStringArray(Object[] values) {
        Objects.requireNonNull(values);
        String[] results = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = values[i] == null ? "$$DBZ-NULL$$" : (values[i] == OracleValueConverters.UNAVAILABLE_VALUE ? "$$DBZ-UNAVAILABLE-VALUE$$" : (String)values[i]);
        }
        return results;
    }
}

