/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.ehcache.serialization;

import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.SerializerInputStream;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.SerializerOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public abstract class AbstractEhcacheSerializer<T>
implements Serializer<T> {
    public ByteBuffer serialize(T object) throws SerializerException {
        ByteBuffer byteBuffer;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            try (SerializerOutputStream stream = new SerializerOutputStream(output);){
                this.serialize(object, stream);
            }
            byteBuffer = ByteBuffer.wrap(output.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SerializerException("Failed to serialize " + object.getClass().getSimpleName(), (Throwable)e);
            }
        }
        output.close();
        return byteBuffer;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public T read(ByteBuffer buffer) throws ClassNotFoundException, SerializerException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(buffer.array());){
            T t;
            if (input.skip(buffer.arrayOffset()) != (long)buffer.arrayOffset()) {
                throw new SerializerException("Failed to adjust buffer offset position before read");
            }
            try (SerializerInputStream stream = new SerializerInputStream(input);){
                t = this.deserialize(stream);
            }
            return t;
        }
        catch (Exception e) {
            throw new SerializerException("Failed to deserialize buffer", (Throwable)e);
        }
    }

    public boolean equals(T object, ByteBuffer buffer) throws ClassNotFoundException, SerializerException {
        return Objects.equals(object, this.read(buffer));
    }

    protected abstract void serialize(T var1, SerializerOutputStream var2) throws IOException;

    protected abstract T deserialize(SerializerInputStream var1) throws IOException;
}

