/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.SingleColumnSqlRedoPreambleParser;
import io.debezium.relational.Table;
import io.debezium.text.ParsingException;
import io.debezium.util.Strings;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractSingleColumnSqlRedoPreambleParser
implements SingleColumnSqlRedoPreambleParser {
    protected static final String DECLARE = "DECLARE";
    protected static final String BEGIN = "BEGIN";
    protected static final String WHERE = "where ";
    protected static final String AND = "and";
    protected static final String OR = "or";
    protected static final String FOR_UPDATE = "for update";
    protected String schemaName;
    protected String tableName;
    protected String columnName;
    protected Object[] columnValues;

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    protected void reset() {
        this.schemaName = null;
        this.tableName = null;
        this.columnName = null;
        this.columnValues = null;
    }

    @Override
    public LogMinerDmlEntry parse(String sql, Table table) throws ParsingException {
        Objects.requireNonNull(table, "The relational table model should not be null");
        this.reset();
        this.columnValues = new Object[table.columns().size()];
        if (!Strings.isNullOrBlank((String)sql)) {
            try {
                this.parseInternal(sql, table);
            }
            catch (Throwable t) {
                throw new ParsingException(null, "Parsing failed for SQL: '" + sql + "'", t);
            }
        }
        LogMinerDmlEntry entry = this.createDmlEntryForColumnValues(this.columnValues);
        entry.setObjectOwner(this.schemaName);
        entry.setObjectName(this.tableName);
        return entry;
    }

    protected abstract void parseInternal(String var1, Table var2);

    protected static int parseQuotedValue(String sql, int index, Consumer<String> collector) {
        boolean inDoubleQuotes = false;
        int startIndex = -1;
        int lastIndex = -1;
        for (int i = index; i < sql.length(); ++i) {
            if (sql.charAt(i) != '\"') continue;
            if (!inDoubleQuotes) {
                inDoubleQuotes = true;
                startIndex = i + 1;
                continue;
            }
            lastIndex = i;
            index = i + 1;
            break;
        }
        if (startIndex != -1 && lastIndex != -1) {
            collector.accept(sql.substring(startIndex, lastIndex));
        }
        return index;
    }

    protected int parseOperator(String sql, int index) {
        boolean initialSpace = false;
        for (int i = index; i < sql.length(); ++i) {
            char lookAhead;
            char c = sql.charAt(i);
            char c2 = lookAhead = i + 1 < sql.length() ? sql.charAt(i + 1) : (char)'\u0000';
            if (initialSpace || c != ' ') {
                if (initialSpace && c == '=' && lookAhead == ' ') {
                    index += 3;
                    break;
                }
                if (initialSpace && c == 'I' && lookAhead == 'S') {
                    char lookAhead2;
                    char c3 = lookAhead2 = i + 2 < sql.length() ? sql.charAt(i + 2) : (char)'\u0000';
                    if (lookAhead2 == ' ') {
                        index += 4;
                        break;
                    }
                    throw new ParsingException(null, "Expected 'IS' at index " + i + ": " + sql);
                }
                throw new ParsingException(null, "Failed to parse operator at index " + i + ": " + sql);
            }
            initialSpace = true;
        }
        return index;
    }

    protected int parseColumnValue(String sql, int index, int columnIndex) {
        boolean inSingleQuotes = false;
        int start = -1;
        int last = -1;
        int nested = 0;
        for (int i = index; i < sql.length(); ++i) {
            char lookAhead;
            char c = sql.charAt(i);
            char c2 = lookAhead = i + 1 < sql.length() ? sql.charAt(i + 1) : (char)'\u0000';
            if (i == index && c != '\'') {
                start = i;
                continue;
            }
            if (c == '(' && !inSingleQuotes) {
                ++nested;
                continue;
            }
            if (c == ')' && !inSingleQuotes) {
                if (--nested != 0) continue;
                last = i + 1;
                index = i + 1;
                break;
            }
            if (c == '\'') {
                if (inSingleQuotes && lookAhead == '\'') {
                    ++i;
                    continue;
                }
                if (inSingleQuotes) {
                    inSingleQuotes = false;
                    if (nested != 0) continue;
                    last = i;
                    index = i + 1;
                    break;
                }
                inSingleQuotes = true;
                if (nested != 0) continue;
                start = i + 1;
                continue;
            }
            if (c != ' ' || inSingleQuotes || nested != 0) continue;
            last = i;
            index = i;
            break;
        }
        if (start != -1) {
            String value;
            if (last != -1) {
                value = sql.substring(start, last);
            } else {
                value = sql.substring(start);
                index = sql.length();
            }
            if (!value.equalsIgnoreCase("null")) {
                this.columnValues[columnIndex] = value;
            }
        }
        return index;
    }

    protected int parseWhereClause(String sql, int index, Table table) {
        for (int i = index; i < sql.length(); ++i) {
            StringBuilder columnName = new StringBuilder();
            index = AbstractSingleColumnSqlRedoPreambleParser.parseQuotedValue(sql, index, columnName::append);
            index = this.parseOperator(sql, index);
            index = this.parseColumnValue(sql, index, LogMinerHelper.getColumnIndexByName(columnName.toString(), table));
            if (sql.indexOf(AND, ++index) == index) {
                index += AND.length() + 1;
                continue;
            }
            if (sql.indexOf(OR, index) == index) {
                index += OR.length() + 1;
                continue;
            }
            if (sql.indexOf(FOR_UPDATE, index) == index || index >= sql.length()) break;
        }
        return index;
    }

    protected abstract LogMinerDmlEntry createDmlEntryForColumnValues(Object[] var1);

    protected static boolean startsWithAtIndex(String startsWithValue, int index, String value) {
        for (int i = 0; i < startsWithValue.length(); ++i) {
            if (value.charAt(index++) == startsWithValue.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected static boolean startsWithAtIndexThrow(String startsWith, int index, String value) {
        if (!AbstractSingleColumnSqlRedoPreambleParser.startsWithAtIndex(startsWith, index, value)) {
            throw new IllegalStateException("Expected to find \"" + startsWith + "\" at position " + index + ": " + value);
        }
        return true;
    }

    protected static int indexOfThrow(String findValue, String value, int fromIndex) {
        int result = value.indexOf(findValue, fromIndex);
        if (result == -1) {
            throw new IllegalStateException("Expected to find \"" + findValue + "\": " + value.substring(fromIndex));
        }
        return result;
    }
}

