/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.olr;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.relational.Column;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.RAW;
import org.apache.kafka.connect.data.Field;

public class OpenLogReplicatorValueConverter
extends OracleValueConverters {
    private static final String COLUMN_TYPE_DATE = "DATE";
    private static final String COMMA = ",";
    private static final String PRECISION = "%precision%";
    private static final String TIMESTAMP_TIME_ZONE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.%precision%xxxxx";
    private static final String TIMESTAMP_LOCAL_TIME_ZONE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.%precision%XXXX";
    private final Map<Integer, DateTimeFormatter> timestampWithTimeZoneFormatterCache = new HashMap<Integer, DateTimeFormatter>();
    private final Map<Integer, DateTimeFormatter> timestampWithLocalTimeZoneFormatterCache = new HashMap<Integer, DateTimeFormatter>();

    public OpenLogReplicatorValueConverter(OracleConnectorConfig connectorConfig, OracleConnection connection) {
        super(connectorConfig, connection);
    }

    @Override
    protected Object convertNumeric(Column column, Field fieldDefn, Object value) {
        return super.convertNumeric(column, fieldDefn, this.toBigDecimal(column, fieldDefn, value));
    }

    @Override
    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object value) {
        if (value instanceof Long) {
            value = this.convertTimestampValue(column, value);
        }
        return super.convertTimestampToEpochMillis(column, fieldDefn, value);
    }

    @Override
    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object value) {
        if (value instanceof Long) {
            value = this.convertTimestampValue(column, value);
        }
        return super.convertTimestampToEpochMicros(column, fieldDefn, value);
    }

    @Override
    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object value) {
        if (value instanceof Long) {
            value = this.convertTimestampValue(column, value);
        }
        return super.convertTimestampToEpochNanos(column, fieldDefn, value);
    }

    @Override
    protected Object convertTimestampToEpochMillisAsDate(Column column, Field fieldDefn, Object value) {
        if (value instanceof Long) {
            value = this.convertTimestampValue(column, value);
        }
        return super.convertTimestampToEpochMillisAsDate(column, fieldDefn, value);
    }

    @Override
    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object value) {
        if (value instanceof String) {
            String valueStr = (String)value;
            if (!valueStr.contains(COMMA)) {
                throw new DebeziumException("Unexpected timestamp with time zone value: " + value);
            }
            String[] valueBits = valueStr.split(COMMA);
            Instant instant = Instant.ofEpochSecond(0L, Long.parseLong(valueBits[0]));
            ZoneId zoneId = this.getZoneIdFromTimeZone(valueBits[1]);
            return this.getTimestampWithTimeZoneFormatter(column).format(OffsetDateTime.ofInstant(instant, zoneId));
        }
        return super.convertTimestampWithZone(column, fieldDefn, value);
    }

    @Override
    protected Object convertTimestampWithLocalZone(Column column, Field fieldDefn, Object value) {
        if (value instanceof Long) {
            Instant instant = Instant.ofEpochSecond(0L, (Long)value);
            return this.getTimestampWithLocalTimeZoneFormatter(column).format(OffsetDateTime.ofInstant(instant, ZoneOffset.UTC));
        }
        return super.convertTimestampWithLocalZone(column, fieldDefn, value);
    }

    @Override
    protected Object convertBinary(Column column, Field fieldDefn, Object value, CommonConnectorConfig.BinaryHandlingMode mode) {
        if (value instanceof String) {
            try {
                value = RAW.hexString2Bytes((String)((String)value));
            }
            catch (SQLException e) {
                throw new DebeziumException("Failed to convert HEX string into byte array: " + value, (Throwable)e);
            }
        }
        return super.convertBinary(column, fieldDefn, value, mode);
    }

    @Override
    protected Object convertIntervalYearMonth(Column column, Field fieldDefn, Object value) {
        if (value instanceof String) {
            value = new INTERVALYM((String)value);
        }
        return super.convertIntervalYearMonth(column, fieldDefn, value);
    }

    @Override
    protected Object convertIntervalDaySecond(Column column, Field fieldDefn, Object value) {
        if (value instanceof String) {
            String sanitizedValue = ((String)value).replaceAll(COMMA, " ");
            value = new INTERVALDS(sanitizedValue);
        }
        return super.convertIntervalDaySecond(column, fieldDefn, value);
    }

    private Object convertTimestampValue(Column column, Object value) {
        value = column.typeName().equalsIgnoreCase(COLUMN_TYPE_DATE) ? Long.valueOf((Long)value / 1000000L) : Instant.ofEpochSecond(0L, (Long)value);
        return value;
    }

    private ZoneId getZoneIdFromTimeZone(String timeZone) {
        if (timeZone.contains(":")) {
            return ZoneOffset.of(timeZone);
        }
        return TimeZone.getTimeZone(timeZone).toZoneId();
    }

    private DateTimeFormatter getTimestampWithTimeZoneFormatter(Column column) {
        int precision = column.scale().orElse(6);
        return this.timestampWithTimeZoneFormatterCache.computeIfAbsent(precision, k -> OpenLogReplicatorValueConverter.createPrecisionBasedFormatter(precision, TIMESTAMP_TIME_ZONE_FORMAT));
    }

    private DateTimeFormatter getTimestampWithLocalTimeZoneFormatter(Column column) {
        int precision = column.scale().orElse(6);
        return this.timestampWithLocalTimeZoneFormatterCache.computeIfAbsent(precision, k -> OpenLogReplicatorValueConverter.createPrecisionBasedFormatter(precision, TIMESTAMP_LOCAL_TIME_ZONE_FORMAT));
    }

    private static DateTimeFormatter createPrecisionBasedFormatter(int precision, String format) {
        String precisionFormat = Strings.pad((String)"", (int)precision, (char)'S');
        return DateTimeFormatter.ofPattern(format.replace(PRECISION, precisionFormat));
    }
}

