/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.relational.TableId;

public class OracleTableIdParser {
    public static TableId parse(String identifier) {
        String[] parts = TableId.parseParts((String)identifier);
        if (parts.length > 3) {
            String tableName = parts[parts.length - 1];
            String schemaName = parts[parts.length - 2];
            String catalogName = OracleTableIdParser.resolveCatalogFromDomainName(parts);
            return new TableId(catalogName, schemaName, tableName);
        }
        return TableId.parse((String)identifier);
    }

    private static String resolveCatalogFromDomainName(String[] parts) {
        StringBuilder catalogName = new StringBuilder(parts[0]);
        for (int index = 1; index < parts.length - 2; ++index) {
            catalogName.append('.').append(parts[index]);
        }
        return catalogName.toString();
    }
}

