/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.jdbc;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.jdbc.BinlogConnectionConfiguration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Strings;

public class MySqlConnectionConfiguration
extends BinlogConnectionConfiguration {
    private static final String JDBC_PROPERTY_CONNECTION_TIME_ZONE = "connectionTimeZone";
    public static final String URL_PATTERN = "${protocol}://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}";

    public MySqlConnectionConfiguration(Configuration config) {
        super(config);
    }

    protected String getConnectionTimeZonePropertyName() {
        return JDBC_PROPERTY_CONNECTION_TIME_ZONE;
    }

    protected String resolveConnectionTimeZone(Configuration dbConfig) {
        return Strings.defaultIfBlank((String)dbConfig.getString(JDBC_PROPERTY_CONNECTION_TIME_ZONE), (String)"SERVER");
    }

    protected Configuration.Builder getDatabaseConfiguration(Configuration configuration) {
        Configuration.Builder builder = super.getDatabaseConfiguration(configuration);
        builder.withDefault(MySqlConnectorConfig.JDBC_PROTOCOL, MySqlConnectorConfig.JDBC_PROTOCOL.defaultValue());
        return builder;
    }

    public String getUrlPattern() {
        return URL_PATTERN;
    }

    protected JdbcConnection.ConnectionFactory createFactory(Configuration configuration) {
        String driverClassName = configuration.getString(MySqlConnectorConfig.JDBC_DRIVER);
        return JdbcConnection.patternBasedFactory((String)URL_PATTERN, (String)driverClassName, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (Field[])new Field[]{MySqlConnectorConfig.JDBC_PROTOCOL});
    }

    public BinlogConnectorConfig.SecureConnectionMode sslMode() {
        String sslMode = this.originalConfig().getString(MySqlConnectorConfig.SSL_MODE);
        return MySqlConnectorConfig.MySqlSecureConnectionMode.parse(sslMode);
    }

    public boolean sslModeEnabled() {
        return this.sslMode() != MySqlConnectorConfig.MySqlSecureConnectionMode.DISABLED;
    }
}

