/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.util.Collect;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;

public class MySqlErrorHandler
extends ErrorHandler {
    @Immutable
    private static final Set<Integer> NON_RETRIABLE_ERROR_CODES = Collect.unmodifiableSet((Object[])new Integer[]{1236});

    public MySqlErrorHandler(MySqlConnectorConfig connectorConfig, ChangeEventQueue<?> queue, ErrorHandler replacedErrorHandler) {
        super(MySqlConnector.class, (CommonConnectorConfig)connectorConfig, queue, replacedErrorHandler);
    }

    protected Set<Class<? extends Exception>> communicationExceptions() {
        return Collect.unmodifiableSet((Object[])new Class[]{IOException.class, SQLException.class});
    }

    protected boolean isRetriable(Throwable throwable) {
        while (throwable != null) {
            SQLException sqlException;
            if (throwable instanceof SQLException && NON_RETRIABLE_ERROR_CODES.contains((sqlException = (SQLException)throwable).getErrorCode())) {
                return false;
            }
            throwable = throwable.getCause();
        }
        return super.isRetriable(throwable);
    }
}

