/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.jdbc;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.jdbc.AbstractFieldReader;
import io.debezium.connector.mysql.jdbc.MySqlValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlTextProtocolFieldReader
extends AbstractFieldReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlTextProtocolFieldReader.class);

    public MySqlTextProtocolFieldReader(MySqlConnectorConfig config) {
        super(config);
    }

    protected Object readTimeField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(columnIndex);
        if (b == null) {
            return null;
        }
        if (b.length() == 0L) {
            LOGGER.warn("Encountered a zero length blob for column index {}", (Object)columnIndex);
            return null;
        }
        try {
            return MySqlValueConverters.stringToDuration((String)new String(b.getBytes(1L, (int)b.length()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.logInvalidValue(rs, columnIndex, b);
            LOGGER.error("Could not read MySQL TIME value as UTF-8. Enable TRACE logging to log the problematic column and its value.");
            throw new RuntimeException(e);
        }
    }

    protected Object readDateField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(columnIndex);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToLocalDate((String)new String(b.getBytes(1L, (int)b.length()), "UTF-8"), (Column)column, (Table)table);
        }
        catch (UnsupportedEncodingException e) {
            this.logInvalidValue(rs, columnIndex, b);
            LOGGER.error("Could not read MySQL DATE value as UTF-8. Enable TRACE logging to log the problematic column and its value.");
            throw new RuntimeException(e);
        }
    }

    protected Object readTimestampField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(columnIndex);
        if (b == null) {
            return null;
        }
        if (b.length() == 0L) {
            LOGGER.warn("Encountered a zero length blob for column index {}", (Object)columnIndex);
            return null;
        }
        try {
            return MySqlValueConverters.containsZeroValuesInDatePart((String)new String(b.getBytes(1L, (int)b.length()), "UTF-8"), (Column)column, (Table)table) ? null : rs.getTimestamp(columnIndex, Calendar.getInstance());
        }
        catch (UnsupportedEncodingException e) {
            this.logInvalidValue(rs, columnIndex, b);
            LOGGER.error("Could not read MySQL DATETIME value as UTF-8. Enable TRACE logging to log the problematic column and its value.");
            throw new RuntimeException(e);
        }
    }
}

