/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.strategy.mariadb;

import com.github.shyiko.mysql.binlog.MariadbGtidSet;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.util.Strings;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MariaDbGtidSet
implements GtidSet {
    private Map<MariaDbGtidStreamId, MariaDbStreamSet> streamSets = new TreeMap<MariaDbGtidStreamId, MariaDbStreamSet>();

    public MariaDbGtidSet(String gtidSet) {
        if (gtidSet != null && !gtidSet.isEmpty()) {
            String[] gtids = gtidSet.replaceAll("\n", "").split(",");
            Arrays.stream(gtids).forEach(gtid -> {
                if (MariadbGtidSet.isMariaGtidSet((String)gtid)) {
                    MariaDbGtid mariaGtid = MariaDbGtid.parse(gtid);
                    MariaDbGtidStreamId streamId = new MariaDbGtidStreamId(mariaGtid);
                    if (!this.streamSets.containsKey(streamId)) {
                        this.streamSets.put(streamId, new MariaDbStreamSet());
                    }
                    this.streamSets.get(streamId).add(mariaGtid);
                }
            });
        }
    }

    protected MariaDbGtidSet(Map<MariaDbGtidStreamId, MariaDbStreamSet> streamSets) {
        this.streamSets = streamSets;
    }

    @Override
    public boolean isEmpty() {
        return this.streamSets.isEmpty();
    }

    @Override
    public GtidSet retainAll(Predicate<String> sourceFilter) {
        if (sourceFilter == null) {
            return this;
        }
        Map<MariaDbGtidStreamId, MariaDbStreamSet> newSets = this.streamSets.entrySet().stream().filter(entry -> sourceFilter.test(((MariaDbGtidStreamId)entry.getKey()).asSourceFilterValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new MariaDbGtidSet(newSets);
    }

    @Override
    public boolean isContainedWithin(GtidSet other) {
        if (!(other instanceof MariaDbGtidSet)) {
            return false;
        }
        if (this.equals(other)) {
            return true;
        }
        MariaDbGtidSet theOther = (MariaDbGtidSet)other;
        for (Map.Entry<MariaDbGtidStreamId, MariaDbStreamSet> entry : this.streamSets.entrySet()) {
            MariaDbStreamSet thatSet = theOther.forStreamId(entry.getKey());
            if (entry.getValue().isContainedWith(thatSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public GtidSet with(GtidSet other) {
        MariaDbGtidSet theOther = (MariaDbGtidSet)other;
        if (theOther == null || theOther.streamSets.isEmpty()) {
            return this;
        }
        HashMap<MariaDbGtidStreamId, MariaDbStreamSet> newSet = new HashMap<MariaDbGtidStreamId, MariaDbStreamSet>();
        newSet.putAll(this.streamSets);
        newSet.putAll(theOther.streamSets);
        return new MariaDbGtidSet(newSet);
    }

    @Override
    public GtidSet getGtidSetBeginning() {
        HashMap<MariaDbGtidStreamId, MariaDbStreamSet> newSet = new HashMap<MariaDbGtidStreamId, MariaDbStreamSet>();
        for (Map.Entry<MariaDbGtidStreamId, MariaDbStreamSet> streamSet : this.streamSets.entrySet()) {
            newSet.put(streamSet.getKey(), streamSet.getValue().asBeginning());
        }
        return new MariaDbGtidSet(newSet);
    }

    @Override
    public boolean contains(String gtid) {
        if (!MariadbGtidSet.isMariaGtidSet((String)gtid)) {
            return false;
        }
        MariaDbGtid mariaGtid = MariaDbGtid.parse(gtid);
        MariaDbStreamSet streamSet = this.forGtidStream(mariaGtid);
        if (streamSet == null) {
            return false;
        }
        return streamSet.contains(mariaGtid);
    }

    @Override
    public MariaDbGtidSet subtract(GtidSet other) {
        if (other == null) {
            return this;
        }
        MariaDbGtidSet theOther = (MariaDbGtidSet)other;
        Map<MariaDbGtidStreamId, MariaDbStreamSet> newSets = this.streamSets.entrySet().stream().filter(entry -> !((MariaDbStreamSet)entry.getValue()).isContainedWith(theOther.forStreamId((MariaDbGtidStreamId)entry.getKey()))).map(entry -> new AbstractMap.SimpleEntry<MariaDbGtidStreamId, MariaDbStreamSet>((MariaDbGtidStreamId)entry.getKey(), ((MariaDbStreamSet)entry.getValue()).subtract(theOther.forStreamId((MariaDbGtidStreamId)entry.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new MariaDbGtidSet(newSets);
    }

    public boolean isKnown(MariaDbGtid gtid) {
        MariaDbStreamSet streamSet = this.forGtidStream(gtid);
        if (streamSet == null) {
            return false;
        }
        return streamSet.hasSequence(gtid.getSequence());
    }

    public MariaDbStreamSet forGtidStream(MariaDbGtid gtid) {
        return this.forStreamId(new MariaDbGtidStreamId(gtid));
    }

    public MariaDbStreamSet forStreamId(MariaDbGtidStreamId streamId) {
        return this.streamSets.get(streamId);
    }

    public static MariaDbGtid parse(String gtid) {
        if (Strings.isNullOrBlank((String)gtid)) {
            throw new IllegalStateException("Cannot parse empty GTID");
        }
        return MariaDbGtid.parse(gtid);
    }

    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null || this.getClass() != value.getClass()) {
            return false;
        }
        MariaDbGtidSet that = (MariaDbGtidSet)value;
        return Objects.equals(this.streamSets, that.streamSets);
    }

    public int hashCode() {
        return Objects.hash(this.streamSets);
    }

    public String toString() {
        return this.streamSets.values().stream().map(MariaDbStreamSet::toString).collect(Collectors.joining(","));
    }

    public static class MariaDbGtidStreamId
    implements Comparable<MariaDbGtidStreamId> {
        private final long domainId;
        private final long serverId;

        public MariaDbGtidStreamId(long domainId, long serverId) {
            this.domainId = domainId;
            this.serverId = serverId;
        }

        public MariaDbGtidStreamId(MariaDbGtid gtid) {
            this(gtid.getDomainId(), gtid.getServerId());
        }

        public long getDomainId() {
            return this.domainId;
        }

        public long getServerId() {
            return this.serverId;
        }

        public String asSourceFilterValue() {
            return String.format("%d-%d", this.domainId, this.serverId);
        }

        public boolean isSameDomainAndServer(MariadbGtidSet.MariaGtid gtid) {
            return gtid.getDomainId() == this.domainId && gtid.getServerId() == this.serverId;
        }

        public boolean equals(Object value) {
            if (this == value) {
                return true;
            }
            if (value == null || this.getClass() != value.getClass()) {
                return false;
            }
            MariaDbGtidStreamId that = (MariaDbGtidStreamId)value;
            return this.domainId == that.domainId && this.serverId == that.serverId;
        }

        public int hashCode() {
            return Objects.hash(this.domainId, this.serverId);
        }

        @Override
        public int compareTo(MariaDbGtidStreamId other) {
            int domainComparison = Long.compare(this.domainId, other.domainId);
            if (domainComparison == 0) {
                return Long.compare(this.serverId, other.serverId);
            }
            return domainComparison;
        }

        public String toString() {
            return "MariaDbGtidStreamId{domainId=" + this.domainId + ", serverId=" + this.serverId + "}";
        }
    }

    public static class MariaDbStreamSet
    extends TreeSet<MariaDbGtid> {
        public boolean hasSequence(long sequence) {
            for (MariaDbGtid gtid : this) {
                if (gtid.getSequence() != sequence) continue;
                return true;
            }
            return false;
        }

        public boolean isContainedWith(MariaDbStreamSet other) {
            if (other == null) {
                return false;
            }
            if (other.containsAll(this)) {
                return true;
            }
            return this.isAllBefore(other);
        }

        public boolean isAllBefore(MariaDbStreamSet other) {
            Long otherMinSequence = other.stream().mapToLong(MariaDbGtid::getSequence).min().getAsLong();
            Long minSequence = this.stream().mapToLong(MariaDbGtid::getSequence).min().getAsLong();
            return minSequence <= otherMinSequence;
        }

        public MariaDbStreamSet subtract(MariaDbStreamSet other) {
            if (other == null) {
                return this;
            }
            MariaDbStreamSet streamSet = new MariaDbStreamSet();
            streamSet.addAll(this.stream().filter(gtid -> !other.contains(gtid)).collect(Collectors.toSet()));
            return streamSet;
        }

        public MariaDbStreamSet asBeginning() {
            MariaDbStreamSet newSet = new MariaDbStreamSet();
            if (!this.isEmpty()) {
                newSet.add((MariaDbGtid)newSet.first());
            }
            return newSet;
        }

        @Override
        public String toString() {
            return this.stream().map(MariaDbGtid::toString).collect(Collectors.joining(","));
        }
    }

    public static class MariaDbGtid
    implements Comparable<MariaDbGtid> {
        private final long domainId;
        private final long serverId;
        private final long sequence;

        public MariaDbGtid(MariadbGtidSet.MariaGtid gtid) {
            this.domainId = gtid.getDomainId();
            this.serverId = gtid.getServerId();
            this.sequence = gtid.getSequence();
        }

        public long getDomainId() {
            return this.domainId;
        }

        public long getServerId() {
            return this.serverId;
        }

        public long getSequence() {
            return this.sequence;
        }

        public static MariaDbGtid parse(String gtid) {
            return new MariaDbGtid(MariadbGtidSet.MariaGtid.parse((String)gtid));
        }

        public boolean equals(Object value) {
            if (this == value) {
                return true;
            }
            if (value == null || this.getClass() != value.getClass()) {
                return false;
            }
            MariaDbGtid that = (MariaDbGtid)value;
            return this.domainId == that.domainId && this.serverId == that.serverId && this.sequence == that.sequence;
        }

        public int hashCode() {
            return Objects.hash(this.domainId, this.serverId, this.sequence);
        }

        @Override
        public int compareTo(MariaDbGtid other) {
            int domainComparison = Long.compare(this.domainId, other.domainId);
            if (domainComparison == 0) {
                int serverComparison = Long.compare(this.serverId, other.serverId);
                if (serverComparison == 0) {
                    return Long.compare(this.sequence, other.sequence);
                }
                return serverComparison;
            }
            return domainComparison;
        }

        public String toString() {
            return this.domainId + "-" + this.serverId + "-" + this.sequence;
        }
    }
}

