/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.network.ServerException;
import io.debezium.config.ConfigurationDefaults;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.mysql.HaltingPredicate;
import io.debezium.connector.mysql.MySqlJdbcContext;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.Reader;
import io.debezium.time.Temporals;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Threads;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReader
implements Reader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String name;
    protected final MySqlTaskContext context;
    protected final MySqlJdbcContext connectionContext;
    private final BlockingQueue<SourceRecord> records;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean success = new AtomicBoolean(false);
    private final AtomicReference<ConnectException> failure = new AtomicReference();
    private ConnectException failureException;
    private final int maxBatchSize;
    private final Metronome metronome;
    private final AtomicReference<Runnable> uponCompletion = new AtomicReference();
    private final Duration pollInterval;
    protected final ChangeEventQueueMetrics changeEventQueueMetrics;
    private final HaltingPredicate acceptAndContinue;

    public AbstractReader(String name, final MySqlTaskContext context, HaltingPredicate acceptAndContinue) {
        this.name = name;
        this.context = context;
        this.connectionContext = context.getConnectionContext();
        this.records = new LinkedBlockingDeque<SourceRecord>(context.getConnectorConfig().getMaxQueueSize());
        this.maxBatchSize = context.getConnectorConfig().getMaxBatchSize();
        this.pollInterval = context.getConnectorConfig().getPollInterval();
        this.metronome = Metronome.parker((Duration)this.pollInterval, (Clock)Clock.SYSTEM);
        this.acceptAndContinue = acceptAndContinue == null ? new AcceptAllPredicate() : acceptAndContinue;
        this.changeEventQueueMetrics = new ChangeEventQueueMetrics(){

            public int totalCapacity() {
                return context.getConnectorConfig().getMaxQueueSize();
            }

            public int remainingCapacity() {
                return AbstractReader.this.records.remainingCapacity();
            }
        };
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void uponCompletion(Runnable handler) {
        assert (this.uponCompletion.get() == null);
        this.uponCompletion.set(handler);
    }

    @Override
    public final void initialize() {
        this.doInitialize();
    }

    @Override
    public final void destroy() {
        this.doDestroy();
    }

    @Override
    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.failure.set(null);
            this.success.set(false);
            this.doStart();
        }
    }

    @Override
    public void stop() {
        try {
            ArrayList unsent = new ArrayList();
            this.records.drainTo(unsent);
            this.logger.info("Discarding {} unsent record(s) due to the connector shutting down", (Object)unsent.size());
            this.doStop();
            this.running.set(false);
        }
        finally {
            if (this.failure.get() != null) {
                this.doCleanup();
            }
        }
    }

    protected void doInitialize() {
    }

    protected void doDestroy() {
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected abstract void doCleanup();

    protected void completeSuccessfully() {
        this.success.set(true);
    }

    protected void failed(Throwable error) {
        this.failure.set(this.wrap(error));
    }

    protected void failed(Throwable error, String msg) {
        ConnectException wrapped = this.wrap(error);
        this.logger.error("Failed due to error: {}", (Object)msg, (Object)wrapped);
        this.failure.set(wrapped);
    }

    protected ConnectException wrap(Throwable error) {
        assert (error != null);
        String msg = error.getMessage();
        if (error instanceof ServerException) {
            ServerException e = (ServerException)error;
            msg = msg + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSqlState() + ".";
        } else if (error instanceof SQLException) {
            SQLException e = (SQLException)error;
            msg = e.getMessage() + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSQLState() + ".";
        }
        return new ConnectException(msg, error);
    }

    @Override
    public Reader.State state() {
        if (this.success.get() || this.failure.get() != null) {
            return Reader.State.STOPPED;
        }
        if (this.running.get()) {
            return Reader.State.RUNNING;
        }
        return Reader.State.STOPPING;
    }

    protected boolean isRunning() {
        return this.running.get();
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        this.failureException = this.failure.get();
        if (this.failureException != null) {
            throw this.failureException;
        }
        if (!this.running.get()) {
            this.cleanupResources();
            throw new InterruptedException("Reader was stopped while polling");
        }
        this.logger.trace("Polling for next batch of records");
        ArrayList<SourceRecord> batch = new ArrayList<SourceRecord>(this.maxBatchSize);
        Threads.Timer timeout = Threads.timer((Clock)Clock.SYSTEM, (Duration)Temporals.min((Duration)this.pollInterval, (Duration)ConfigurationDefaults.RETURN_CONTROL_INTERVAL));
        while (this.running.get() && this.records.drainTo(batch, this.maxBatchSize) == 0 && !this.success.get()) {
            this.metronome.pause();
            this.failureException = this.failure.get();
            if (this.failureException != null) {
                throw this.failureException;
            }
            if (!timeout.expired()) continue;
        }
        if (batch.isEmpty() && this.success.get() && this.records.isEmpty()) {
            this.running.set(false);
            this.cleanupResources();
            return null;
        }
        this.pollComplete(batch);
        this.logger.trace("Completed batch of {} records", (Object)batch.size());
        return batch;
    }

    protected void cleanupResources() {
        try {
            this.doCleanup();
        }
        finally {
            Runnable completionHandler = this.uponCompletion.getAndSet(null);
            if (completionHandler != null) {
                completionHandler.run();
            }
        }
    }

    protected void pollComplete(List<SourceRecord> batch) {
    }

    protected void enqueueRecord(SourceRecord record) throws InterruptedException {
        if (record != null && this.running.get()) {
            if (this.acceptAndContinue.accepts(record)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Enqueuing source record: {}", (Object)record);
                }
                this.records.put(record);
            } else {
                this.logger.info("predicate returned false; completing reader {}", (Object)this.name);
                this.completeSuccessfully();
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public static class AcceptAllPredicate
    implements HaltingPredicate {
        @Override
        public boolean accepts(SourceRecord sourceRecord) {
            return true;
        }
    }
}

