/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.changestream.OperationType;
import io.debezium.DebeziumException;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.data.Envelope;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeStreamPipelineFactory {
    public static final String LIST_DELIMITER = ",";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeStreamPipelineFactory.class);
    private final MongoDbConnectorConfig connectorConfig;
    private final Filters.FilterConfig filterConfig;

    ChangeStreamPipelineFactory(MongoDbConnectorConfig connectorConfig, Filters.FilterConfig filterConfig) {
        this.connectorConfig = connectorConfig;
        this.filterConfig = filterConfig;
    }

    ChangeStreamPipeline create() {
        ChangeStreamPipeline sizePipeline = this.createSizePipeline();
        ChangeStreamPipeline splitPipeline = this.createSplitPipeline();
        ChangeStreamPipeline userAndInternalPipeline = this.createUserAndInternalPipeline();
        ChangeStreamPipeline effectivePipeline = sizePipeline.then(userAndInternalPipeline).then(splitPipeline);
        LOGGER.info("Effective change stream pipeline: {}", (Object)effectivePipeline);
        return effectivePipeline;
    }

    private ChangeStreamPipeline createUserAndInternalPipeline() {
        ChangeStreamPipeline internalPipeline = this.createInternalPipeline();
        ChangeStreamPipeline userPipeline = this.createUserPipeline();
        switch (this.connectorConfig.getCursorPipelineOrder()) {
            case INTERNAL_FIRST: {
                return internalPipeline.then(userPipeline);
            }
            case USER_FIRST: {
                return userPipeline.then(internalPipeline);
            }
            case USER_ONLY: {
                return userPipeline;
            }
        }
        throw new DebeziumException("Unknown aggregation pipeline order");
    }

    private ChangeStreamPipeline createSizePipeline() {
        if (this.connectorConfig.getOversizeHandlingMode() != MongoDbConnectorConfig.OversizeHandlingMode.SKIP) {
            return new ChangeStreamPipeline(new Bson[0]);
        }
        int threshold = this.connectorConfig.getOversizeSkipThreshold();
        Bson fullDocument = ChangeStreamPipelineFactory.expr(ChangeStreamPipelineFactory.lte(ChangeStreamPipelineFactory.bsonSize("$fullDocument"), threshold));
        Bson fullDocumentBeforeChange = ChangeStreamPipelineFactory.expr(ChangeStreamPipelineFactory.lte(ChangeStreamPipelineFactory.bsonSize("$fullDocumentBeforeChange"), threshold));
        Bson stage = Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{fullDocument, fullDocumentBeforeChange}));
        return new ChangeStreamPipeline(stage);
    }

    private ChangeStreamPipeline createSplitPipeline() {
        if (this.connectorConfig.getOversizeHandlingMode() != MongoDbConnectorConfig.OversizeHandlingMode.SPLIT) {
            return new ChangeStreamPipeline(new Bson[0]);
        }
        return new ChangeStreamPipeline(ChangeStreamPipelineFactory.splitLargeEvent());
    }

    private ChangeStreamPipeline createInternalPipeline() {
        List filters = Stream.of(ChangeStreamPipelineFactory.createCollectionFilter(this.filterConfig), ChangeStreamPipelineFactory.createOperationTypeFilter(this.connectorConfig, this.filterConfig)).flatMap(Optional::stream).collect(Collectors.toList());
        Bson andFilter = Filters.and(filters);
        Bson matchFilter = Aggregates.match((Bson)andFilter);
        if (this.filterConfig.isLiteralsMatchMode()) {
            return new ChangeStreamPipeline(matchFilter);
        }
        return this.createRegexMatchingInternalPipeline(matchFilter);
    }

    private ChangeStreamPipeline createRegexMatchingInternalPipeline(Bson matchFilter) {
        return new ChangeStreamPipeline(Aggregates.replaceRoot((Object)new BasicDBObject(Map.of("namespace", ChangeStreamPipelineFactory.concat("$ns.db", ".", "$ns.coll"), "event", "$$ROOT"))), matchFilter, Aggregates.replaceRoot((Object)"$event"));
    }

    private ChangeStreamPipeline createUserPipeline() {
        return this.filterConfig.getUserPipeline();
    }

    private static Optional<Bson> createDatabaseAndCollectionRegexFilters(Filters.FilterConfig filterConfig) {
        Optional dbFilters = Optional.empty().or(() -> filterConfig.getDbIncludeList().map(value -> Filters.regex((String)"event.ns.db", (String)Strings.join((CharSequence)"|", ChangeStreamPipelineFactory.splitList(value)), (String)"i"))).or(() -> filterConfig.getDbExcludeList().map(value -> Filters.regex((String)"event.ns.db", (String)("(?!" + Strings.join((CharSequence)"|", ChangeStreamPipelineFactory.splitList(value)) + ")"), (String)"i")));
        Optional collectionsFilters = Optional.empty().or(() -> filterConfig.getCollectionIncludeList().map(value -> Filters.regex((String)"namespace", (String)Strings.join((CharSequence)"|", ChangeStreamPipelineFactory.splitList(value)), (String)"i"))).or(() -> filterConfig.getCollectionExcludeList().map(value -> Filters.regex((String)"namespace", (String)("(?!" + Strings.join((CharSequence)"|", ChangeStreamPipelineFactory.splitList(value)) + ")"), (String)"i")));
        return ChangeStreamPipelineFactory.andFilters(dbFilters, collectionsFilters);
    }

    private static Optional<Bson> createDatabaseAndCollectionLiteralFilters(Filters.FilterConfig filterConfig) {
        Optional dbFilters = Optional.empty().or(() -> filterConfig.getDbIncludeList().map(ChangeStreamPipelineFactory::splitList).map(dbs -> Filters.in((String)"ns.db", (Iterable)dbs))).or(() -> filterConfig.getDbExcludeList().map(ChangeStreamPipelineFactory::splitList).map(dbs -> Filters.nin((String)"ns.db", (Iterable)dbs)));
        Optional collectionsFilters = Optional.empty().or(() -> filterConfig.getCollectionIncludeList().map(ChangeStreamPipelineFactory::splitNamespaceList).map(nss -> Filters.in((String)"ns", (Iterable)nss))).or(() -> filterConfig.getCollectionExcludeList().map(ChangeStreamPipelineFactory::splitNamespaceList).map(nss -> Filters.nin((String)"ns", (Iterable)nss)));
        return ChangeStreamPipelineFactory.andFilters(dbFilters, collectionsFilters);
    }

    private static Optional<Bson> createCollectionFilter(Filters.FilterConfig filterConfig) {
        Optional<Object> dbAndCollectionFilters = Optional.empty();
        Optional<Object> includedSignalCollectionFilters = Optional.empty();
        if (filterConfig.isLiteralsMatchMode()) {
            dbAndCollectionFilters = ChangeStreamPipelineFactory.createDatabaseAndCollectionLiteralFilters(filterConfig);
            includedSignalCollectionFilters = filterConfig.getSignalDataCollection().map(ChangeStreamPipelineFactory::namespaceBson).map(ns -> Filters.eq((String)"ns", (Object)ns));
        } else {
            dbAndCollectionFilters = ChangeStreamPipelineFactory.createDatabaseAndCollectionRegexFilters(filterConfig);
            includedSignalCollectionFilters = filterConfig.getSignalDataCollection().map(col -> Filters.eq((String)"namespace", (Object)col));
        }
        return ChangeStreamPipelineFactory.orFilters(dbAndCollectionFilters, includedSignalCollectionFilters);
    }

    private static Optional<Bson> createOperationTypeFilter(MongoDbConnectorConfig connectorConfig, Filters.FilterConfig filterConfig) {
        ArrayList<OperationType> includedOperations = new ArrayList<OperationType>();
        includedOperations.add(OperationType.INSERT);
        includedOperations.add(OperationType.UPDATE);
        includedOperations.add(OperationType.REPLACE);
        includedOperations.add(OperationType.DELETE);
        EnumSet skippedOperations = connectorConfig.getSkippedOperations();
        if (skippedOperations.contains(Envelope.Operation.CREATE)) {
            includedOperations.remove(OperationType.INSERT);
        }
        if (skippedOperations.contains(Envelope.Operation.UPDATE)) {
            includedOperations.remove(OperationType.UPDATE);
            includedOperations.remove(OperationType.REPLACE);
        }
        if (skippedOperations.contains(Envelope.Operation.DELETE)) {
            includedOperations.remove(OperationType.DELETE);
        }
        String field = filterConfig.isLiteralsMatchMode() ? "operationType" : "event.operationType";
        return Optional.of(Filters.in((String)field, (Iterable)includedOperations.stream().map(OperationType::getValue).collect(Collectors.toList())));
    }

    @SafeVarargs
    private static Optional<Bson> andFilters(Optional<Bson> ... filters) {
        List<Bson> resolved = ChangeStreamPipelineFactory.resolveFilters(filters);
        return ChangeStreamPipelineFactory.andFilters(resolved);
    }

    private static Optional<Bson> andFilters(List<Bson> filters) {
        if (filters.isEmpty()) {
            return Optional.empty();
        }
        if (filters.size() == 1) {
            return Optional.of(filters.get(0));
        }
        return Optional.of(Filters.and(filters));
    }

    @SafeVarargs
    private static Optional<Bson> orFilters(Optional<Bson> ... filters) {
        List<Bson> resolved = ChangeStreamPipelineFactory.resolveFilters(filters);
        return ChangeStreamPipelineFactory.orFilters(resolved);
    }

    private static Optional<Bson> orFilters(List<Bson> filters) {
        if (filters.isEmpty()) {
            return Optional.empty();
        }
        if (filters.size() == 1) {
            return Optional.of(filters.get(0));
        }
        return Optional.of(Filters.or(filters));
    }

    @SafeVarargs
    private static List<Bson> resolveFilters(Optional<Bson> ... filters) {
        return Stream.of(filters).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private static Bson splitLargeEvent() {
        return new BasicDBObject("$changeStreamSplitLargeEvent", (Object)new BasicDBObject());
    }

    private static Bson concat(Object ... expressions) {
        return new BasicDBObject("$concat", List.of(expressions));
    }

    private static Bson bsonSize(Object document) {
        return new BasicDBObject("$bsonSize", document);
    }

    private static Bson lte(Object expr1, Object expr2) {
        return new BasicDBObject("$lte", List.of(expr1, expr2));
    }

    private static Bson expr(Object expr) {
        return new BasicDBObject("$expr", expr);
    }

    private static Bson namespaceBson(String namespace) {
        String[] nsAndCol = namespace.trim().split("\\.", 2);
        return new BasicDBObject().append("db", (Object)nsAndCol[0]).append("coll", (Object)nsAndCol[1]);
    }

    private static List<String> splitList(String input) {
        String[] parts = input.split(LIST_DELIMITER);
        return Stream.of(parts).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.toList());
    }

    private static List<Bson> splitNamespaceList(String input) {
        String[] parts = input.split(LIST_DELIMITER);
        return Stream.of(parts).map(String::trim).filter(Predicate.not(String::isEmpty)).map(ChangeStreamPipelineFactory::namespaceBson).collect(Collectors.toList());
    }
}

