/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms.outbox;

import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.transforms.ExtractNewDocumentState;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.connector.mongodb.transforms.outbox.MongoEventRouterConfigDefinition;
import io.debezium.time.Timestamp;
import io.debezium.transforms.ConnectRecordUtil;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import io.debezium.transforms.outbox.EventRouterDelegate;
import io.debezium.transforms.tracing.ActivateTracingSpan;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Transformation;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class MongoEventRouter<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoEventRouter.class);
    private final JsonWriterSettings jsonWriterSettings = JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).indent(true).newLineCharacters("\n").build();
    private final MongoDataConverter converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
    private String fieldTimestamp;
    private String fieldPayload;
    private boolean expandPayload;
    private ExtractField<R> afterExtractor;
    private final EventRouterDelegate<R> eventRouterDelegate = new EventRouterDelegate();

    public R apply(R r) {
        return (R)this.eventRouterDelegate.apply(r, record -> {
            try {
                return this.expandAfterField(r);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to expand after field: " + e.getMessage(), (Throwable)e);
                return r;
            }
        });
    }

    public ConfigDef config() {
        return MongoEventRouterConfigDefinition.configDef();
    }

    public void close() {
        this.eventRouterDelegate.close();
    }

    public void configure(Map<String, ?> configMap) {
        Configuration config = Configuration.from(configMap);
        this.fieldTimestamp = config.getString(MongoEventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP);
        this.expandPayload = config.getBoolean(MongoEventRouterConfigDefinition.EXPAND_JSON_PAYLOAD);
        this.fieldPayload = config.getString(MongoEventRouterConfigDefinition.FIELD_PAYLOAD);
        this.afterExtractor = ConnectRecordUtil.extractAfterDelegate();
        Map<String, ?> convertedConfigMap = this.convertConfigMap(configMap);
        this.eventRouterDelegate.configure(convertedConfigMap);
    }

    public String version() {
        return Module.version();
    }

    private R expandAfterField(R originalRecord) throws IllegalStateException {
        ConnectRecord afterRecord = this.afterExtractor.apply(originalRecord);
        Object after = afterRecord.value();
        if (!(after instanceof String)) {
            throw new IllegalStateException("Unable to expand non-String after field: " + String.valueOf(after.getClass()));
        }
        Schema originalValueSchema = originalRecord.valueSchema();
        String afterSchemaName = afterRecord.valueSchema().name();
        BsonDocument afterBsonDocument = BsonDocument.parse((String)((String)after));
        Schema newAfterSchema = this.buildNewAfterSchema(afterSchemaName, afterBsonDocument);
        Struct newAfterStruct = this.buildNewAfterStruct(newAfterSchema, afterBsonDocument);
        String valueSchemaName = originalValueSchema.name();
        Schema newValueSchema = this.buildNewValueSchema(valueSchemaName, originalValueSchema, newAfterSchema);
        Struct newValueStruct = this.buildNewValueStruct((Struct)originalRecord.value(), newValueSchema, newAfterStruct);
        return (R)originalRecord.newRecord(originalRecord.topic(), originalRecord.kafkaPartition(), originalRecord.keySchema(), originalRecord.key(), newValueSchema, (Object)newValueStruct, originalRecord.timestamp(), (Iterable)originalRecord.headers());
    }

    private Schema buildNewAfterSchema(String schemaName, BsonDocument afterBsonDocument) {
        SchemaBuilder afterSchemaBuilder = SchemaBuilder.struct().name(schemaName);
        Map<String, Map<Object, BsonType>> afterSchemaMap = this.converter.parseBsonDocument(afterBsonDocument);
        for (Map.Entry entry : afterBsonDocument.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (entryKey.equals(this.fieldTimestamp)) {
                afterSchemaBuilder.field(this.fieldTimestamp, Timestamp.schema());
                continue;
            }
            if (!entryKey.equals(this.fieldPayload) || this.expandPayload || !(entry.getValue() instanceof BsonDocument)) continue;
            afterSchemaBuilder.field(this.fieldPayload, Schema.OPTIONAL_STRING_SCHEMA);
        }
        this.converter.buildSchema(afterSchemaMap, afterSchemaBuilder);
        return afterSchemaBuilder.build();
    }

    private Struct buildNewAfterStruct(Schema afterSchema, BsonDocument afterBsonDocument) {
        Struct afterStruct = new Struct(afterSchema);
        for (Map.Entry entry : afterBsonDocument.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (entryKey.equals(this.fieldTimestamp)) {
                afterStruct.put(this.fieldTimestamp, (Object)((BsonValue)entry.getValue()).asInt64().getValue());
                continue;
            }
            if (entryKey.equals(this.fieldPayload) && !this.expandPayload && entry.getValue() instanceof BsonDocument) {
                afterStruct.put(this.fieldPayload, (Object)((BsonValue)entry.getValue()).asDocument().toJson(this.jsonWriterSettings));
                continue;
            }
            this.converter.buildStruct(entry, afterSchema, afterStruct);
        }
        return afterStruct;
    }

    private Schema buildNewValueSchema(String valueSchemaName, Schema originalValueSchema, Schema afterSchema) {
        SchemaBuilder valueSchemaBuilder = SchemaBuilder.struct().name(valueSchemaName);
        for (Field field : originalValueSchema.fields()) {
            if (field.name().equals("after")) continue;
            valueSchemaBuilder.field(field.name(), field.schema());
        }
        valueSchemaBuilder.field("after", afterSchema);
        return valueSchemaBuilder.build();
    }

    private Struct buildNewValueStruct(Struct originalValueStruct, Schema newValueSchema, Struct newAfterStruct) {
        Struct newValueStruct = new Struct(newValueSchema);
        for (Field field : originalValueStruct.schema().fields()) {
            if (field.name().equals("after")) continue;
            newValueStruct.put(field.name(), originalValueStruct.get(field));
        }
        newValueStruct.put("after", (Object)newAfterStruct);
        return newValueStruct;
    }

    private <T> Map<String, T> convertConfigMap(Map<String, T> oldConfigMap) {
        Map<String, String> fieldNameConverter = this.createFieldNameConverter();
        HashMap<String, Object> newConfigMap = new HashMap<String, Object>();
        for (String config : oldConfigMap.keySet()) {
            if (!fieldNameConverter.containsKey(config)) continue;
            newConfigMap.put(fieldNameConverter.get(config), oldConfigMap.get(config));
        }
        if (!this.hasConfigFieldEventId(newConfigMap)) {
            newConfigMap.put(EventRouterConfigDefinition.FIELD_EVENT_ID.name(), MongoEventRouterConfigDefinition.FIELD_EVENT_ID.defaultValue());
        }
        return newConfigMap;
    }

    private <T> boolean hasConfigFieldEventId(Map<String, T> configMap) {
        return configMap.containsKey(EventRouterConfigDefinition.FIELD_EVENT_ID.name());
    }

    private Map<String, String> createFieldNameConverter() {
        HashMap<String, String> fieldNameConverter = new HashMap<String, String>();
        fieldNameConverter.put(MongoEventRouterConfigDefinition.FIELD_EVENT_ID.name(), EventRouterConfigDefinition.FIELD_EVENT_ID.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.FIELD_EVENT_KEY.name(), EventRouterConfigDefinition.FIELD_EVENT_KEY.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.FIELD_EVENT_TYPE.name(), EventRouterConfigDefinition.FIELD_EVENT_TYPE.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP.name(), EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.FIELD_PAYLOAD.name(), EventRouterConfigDefinition.FIELD_PAYLOAD.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.FIELDS_ADDITIONAL_PLACEMENT.name(), EventRouterConfigDefinition.FIELDS_ADDITIONAL_PLACEMENT.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.FIELD_SCHEMA_VERSION.name(), EventRouterConfigDefinition.FIELD_SCHEMA_VERSION.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.ROUTE_BY_FIELD.name(), EventRouterConfigDefinition.ROUTE_BY_FIELD.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.ROUTE_TOPIC_REGEX.name(), EventRouterConfigDefinition.ROUTE_TOPIC_REGEX.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.ROUTE_TOPIC_REPLACEMENT.name(), EventRouterConfigDefinition.ROUTE_TOPIC_REPLACEMENT.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.ROUTE_TOMBSTONE_ON_EMPTY_PAYLOAD.name(), EventRouterConfigDefinition.ROUTE_TOMBSTONE_ON_EMPTY_PAYLOAD.name());
        fieldNameConverter.put(MongoEventRouterConfigDefinition.OPERATION_INVALID_BEHAVIOR.name(), EventRouterConfigDefinition.OPERATION_INVALID_BEHAVIOR.name());
        fieldNameConverter.put(ActivateTracingSpan.TRACING_SPAN_CONTEXT_FIELD.name(), ActivateTracingSpan.TRACING_SPAN_CONTEXT_FIELD.name());
        fieldNameConverter.put(ActivateTracingSpan.TRACING_OPERATION_NAME.name(), ActivateTracingSpan.TRACING_OPERATION_NAME.name());
        fieldNameConverter.put(ActivateTracingSpan.TRACING_CONTEXT_FIELD_REQUIRED.name(), ActivateTracingSpan.TRACING_CONTEXT_FIELD_REQUIRED.name());
        return fieldNameConverter;
    }

    EventRouterDelegate<R> getEventRouterDelegate() {
        return this.eventRouterDelegate;
    }
}

