/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink;

import com.mongodb.MongoNamespace;
import com.mongodb.client.model.WriteModel;
import io.debezium.connector.mongodb.sink.MongoDbSinkConnectorConfig;
import io.debezium.connector.mongodb.sink.converters.SinkDocument;
import io.debezium.connector.mongodb.sink.converters.SinkRecordConverter;
import io.debezium.connector.mongodb.sink.eventhandler.relational.RelationalEventHandler;
import io.debezium.sink.DebeziumSinkRecord;
import java.util.Optional;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoProcessedSinkRecordData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoProcessedSinkRecordData.class);
    private final MongoDbSinkConnectorConfig config;
    private final MongoNamespace namespace;
    private final DebeziumSinkRecord sinkRecord;
    private final SinkDocument sinkDocument;
    private final WriteModel<BsonDocument> writeModel;
    private Exception exception;
    private final String databaseName;

    MongoProcessedSinkRecordData(DebeziumSinkRecord sinkRecord, MongoDbSinkConnectorConfig sinkConfig) {
        this.sinkRecord = sinkRecord;
        this.databaseName = sinkConfig.getSinkDatabaseName();
        this.config = sinkConfig;
        this.sinkDocument = new SinkRecordConverter().convert(sinkRecord);
        this.namespace = this.createNamespace();
        this.writeModel = this.createWriteModel();
    }

    public MongoDbSinkConnectorConfig getConfig() {
        return this.config;
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public DebeziumSinkRecord getSinkRecord() {
        return this.sinkRecord;
    }

    public WriteModel<BsonDocument> getWriteModel() {
        return this.writeModel;
    }

    public Exception getException() {
        return this.exception;
    }

    public SinkDocument getSinkDocument() {
        return this.sinkDocument;
    }

    private MongoNamespace createNamespace() {
        return this.tryProcess(() -> Optional.of(new MongoNamespace(this.databaseName, this.config.getCollectionNamingStrategy().resolveCollectionName(this.sinkRecord, this.config.getCollectionNameFormat())))).orElse(null);
    }

    private WriteModel<BsonDocument> createWriteModel() {
        return this.tryProcess(() -> new RelationalEventHandler(this.config).handle(this.sinkDocument)).orElse(null);
    }

    private <T> Optional<T> tryProcess(Supplier<Optional<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            this.exception = e;
            LOGGER.error("Unable to process record {}", (Object)this.sinkRecord, (Object)e);
            return Optional.empty();
        }
    }
}

